package org.lsst.ccs.description.groovy;

import java.lang.reflect.Constructor
import java.lang.reflect.Parameter
import java.lang.reflect.Field
import java.lang.reflect.Method
import org.lsst.ccs.config.ConfigurationHandlerBuilder;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.*;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

class GroovyConstructorInvoker {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.groovy");
    private static final Map<Class,List<String>> constructorsMap = new HashMap<>();

    Object invokeConstructor(String nodeName, Class cls, Map args, ComponentNode topNode) {
        // Second strategy : finding the best constructor and setting other fields.
        Constructor[] ctors = cls.getConstructors();
        Map<String, Object> bestArgs = new HashMap<>();
        
        for (Constructor c : ctors) {
            Map<String, Object> matchArgs = new LinkedHashMap<>();
            Parameter[] parms = c.parameters;
            for (Parameter p : parms) {
                if (args.containsKey(p.getName())) {
                    matchArgs.put(p.getName(), args.get(p.getName()))
                } else {
                    /* 
                     * In this case one of the constructor's parameters does 
                     * not mach the provided arguments.We then clear the 
                     * matching list and move to the next constructor definition
                     */
                    matchArgs.clear();
                    break;
                }
            }
            if (matchArgs.size() > bestArgs.size()) {
                bestArgs = matchArgs;
            }
        }
        

//        if (bestArgs.size() == 0) {
//            // let groovy invoke empty constructor and set fields
//            return cls.metaClass.invokeConstructor(args);
//        } else {
            // invoke the found constructor and set other fields by hand

            if( bestArgs.size() > 0 ) {
                String ctrArgs = "";
                for ( String arg : bestArgs.keySet() ) {
                    if ( !ctrArgs.isEmpty() ) {
                        ctrArgs += ",";
                    }
                    ctrArgs += " "+arg;
                }
                List<String> argsForCtr = constructorsMap.getOrDefault(cls, new ArrayList<String>());
                if ( ! argsForCtr.contains(ctrArgs) ) {
                    log.log(Level.WARNING,"Class "+cls.getSimpleName()+" has been built in Groovy with a non empty constructor with parameters:("+ctrArgs+") for node "+nodeName);
                    argsForCtr.add(ctrArgs);
                    constructorsMap.put(cls,argsForCtr);
                }
            }

            Object res = cls.metaClass.invokeConstructor(bestArgs.values().toArray())

            //Could this be made more efficient?
            //Creating it only once?
            ConfigurationHandlerSet configHandlerSet = new ConfigurationHandlerSet();
            configHandlerSet.addConfigurationHandlerForObject(nodeName, res);

            ConfigurationHandler configurationHandler = configHandlerSet.getConfigurationHandlerForGroovy(nodeName);

            Map<String, Field> fields = ConfigurationHandlerBuilder.buildParameterFieldsMap(cls,res);
            Map<String, Method> methods = ConfigurationHandlerBuilder.buildConfigChangerMap(cls,res);
 
            //Check if any of the constructor's arguments is a Configuration Parameter
            Map<String,Object> argsToRemove = new HashMap<>();

            for (Map.Entry<String, Object> entry : bestArgs.entrySet()) {
                String name = entry.getKey();
                if ( configurationHandler != null && configurationHandler.isParameterConfigurable(name) ) {
                    throw new RuntimeException("Trying to set configuration parameter "+name+" from groovy. This is no longer allowed. Please remove it.");
                } else {
                    argsToRemove.put(entry.getKey(),entry.getValue());
                }
            }

            args.keySet().removeAll(argsToRemove.keySet())
            

            // Setting other fields 
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                String name = entry.getKey();
                if ( configurationHandler != null && configurationHandler.isParameterConfigurable(name) ) {
                    throw new RuntimeException("Trying to set configuration parameter "+name+" from groovy. This is no longer allowed. Please remove it.");
                }
                res."$name"=entry.getValue();
            }
            return res;
//        }
    }
    
}

