package org.lsst.ccs.description.groovy;

import java.util.Map;
import org.lsst.ccs.description.ComponentNode;
import static org.lsst.ccs.description.ComponentNode.logger;

/**
 * Specific implementation of a ComponentNode, built from a groovy description.
 * @author bamade
 */

class GroovyComponentNode extends ComponentNode<GroovyComponentNode> {
    
    private static final String NODE_TAGS_NAME = "nodeTags";
    private static final long serialVersionUID = 4549184140768627636L;
    
    protected Class cls;
    
    protected Map attributes;

    GroovyComponentNode(String name, Map attributes,  Class cls) {
        super(name);
        
        logger.debug("Building component node "+name+" "+attributes+" "+cls);
        if ( attributes.containsKey(NODE_TAGS_NAME) ) {
            Object nodetags = attributes.remove(NODE_TAGS_NAME);
            if ( ! (nodetags instanceof Map) ) {
                throw new RuntimeException("Node tags must be provided as a Map: "+NODE_TAGS_NAME+" "+tags);                
            }
            tags.putAll((Map)nodetags);
        }
        
        this.cls = cls;
        this.attributes = attributes;
    }
    
    public Map getAttributes() {
        return attributes;
    }
    
    public Class getCls() {
        return cls;
    }
    
    public void setCls(Class cls) { 
        this.cls = cls;
    }

}
