/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rebps;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.rebps.RebPs;

public class TestRebPs {
    private final RebPs ps = new RebPs();

    @Command(name="connect", description="Open connection to device")
    public void connect(@Argument(name="ipaddr", description="IP address") String ipAddr, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.ps.open(ipAddr, port);
    }

    @Command(name="connect", description="Open connection to device")
    public void connect(@Argument(name="ipaddr", description="IP address") String ipAddr) throws DriverException {
        this.ps.open(ipAddr);
    }

    @Command(name="disconnect", description="Close connection to device")
    public void disconnect() throws DriverException {
        this.ps.close();
    }

    @Command(name="read", description="Read a register")
    public String read(@Argument(name="addr", description="Register address") int addr) throws DriverException {
        return String.format("%08x", this.ps.readReg(addr));
    }

    @Command(name="read", description="Reads registers")
    public String read(@Argument(name="addr", description="Register address") int addr, @Argument(name="count", description="Register count") int count) throws DriverException {
        return this.formatHex(addr, this.ps.readRegs(addr, count));
    }

    @Command(name="write", description="Write a register")
    public void write(@Argument(name="addr", description="Register address") int addr, int ... value) throws DriverException {
        this.ps.writeRegs(addr, value);
    }

    @Command(name="update", description="Update a register")
    public void update(@Argument(name="addr", description="Register address") int addr, @Argument(name="mask", description="Mask of bits to change") int mask, @Argument(name="value", description="Register value") int value) throws DriverException {
        this.ps.updateReg(addr, mask, value);
    }

    @Command(name="showserial", description="Show the serial number")
    public String showSerial() throws DriverException {
        return String.format("%016x", this.ps.getSerialNo());
    }

    @Command(name="showfirmware", description="Show the firmware version")
    public String showFirmware() throws DriverException {
        return String.format("%08x", this.ps.getFwVersion());
    }

    @Command(name="showgeogaddr", description="Show the geographical address")
    public String showGeogAddr() throws DriverException {
        return String.valueOf(this.ps.getGeogAddr());
    }

    @Command(name="configure", description="Configure a device")
    public void configure(@Argument(name="rebNum", description="REB number") int rebNum, @Argument(name="psNum", description="Power supply number") int psNum, @Argument(name="device", description="Device number") int devc) throws DriverException {
        this.ps.configure(rebNum, psNum, devc);
    }

    @Command(name="configure", description="Configure all devices in a PS")
    public void configure(@Argument(name="rebNum", description="REB number") int rebNum, @Argument(name="psNum", description="Power supply number") int psNum) throws DriverException {
        this.ps.configure(rebNum, psNum);
    }

    @Command(name="configure", description="Configure all devices in a REB")
    public void configure(@Argument(name="rebNum", description="REB number") int rebNum) throws DriverException {
        this.ps.configure(rebNum);
    }

    @Command(name="readchannel", description="Show a channel value")
    public String readChannel(@Argument(name="rebNum", description="REB number") int rebNum, @Argument(name="psNum", description="Power supply number") int psNum, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return String.format("%.3f", this.ps.readChannel(rebNum, psNum, chan));
    }

    @Command(name="readchannel", description="Show channel values")
    public String readChannel(@Argument(name="rebNum", description="REB number") int rebNum, @Argument(name="psNum", description="Power supply number") int psNum) throws DriverException {
        double[] values = this.ps.readChannel(rebNum, psNum);
        StringBuilder text = new StringBuilder(String.format("PS%s:", psNum));
        for (double value : values) {
            text.append(String.format("  %.2f", value));
        }
        return text.toString();
    }

    @Command(name="readchannel", description="Show channel values")
    public String readChannel(@Argument(name="rebNum", description="REB number") int rebNum) throws DriverException {
        StringBuilder text = new StringBuilder(this.readChannel(rebNum, 0));
        for (int psNum = 1; psNum < 7; ++psNum) {
            text.append("\n");
            text.append(this.readChannel(rebNum, psNum));
        }
        return text.toString();
    }

    @Command(name="writedac", description="Write to a DAC")
    public void writeDac(@Argument(name="rebNum", description="REB number") int rebNum, @Argument(name="psNum", description="Power supply number") int psNum, @Argument(name="value", description="DAC value") double value) throws DriverException {
        this.ps.writeDac(rebNum, psNum, value);
    }

    @Command(name="settempres", description="Set the temperature resolution")
    public void setTemperatureRes(@Argument(name="resolution", description="Resolution value") int res) throws DriverException {
        this.ps.setTemperatureRes(res);
    }

    @Command(name="showtemp", description="Show the temperature")
    public String showTemperature() throws DriverException {
        return String.format("%.2f", this.ps.readTemperature());
    }

    @Command(name="setpower", description="Sets the power")
    public void setPower(@Argument(name="reb", description="REB number") int rebNum, @Argument(name="action", description="Action value") int action) throws DriverException {
        this.ps.setPower(rebNum, action);
    }

    @Command(name="showpower", description="Show the power")
    public String showPower(@Argument(name="reb", description="REB number") int rebNum) throws DriverException {
        return String.format("0x%02x", this.ps.getPower(rebNum));
    }

    @Command(name="showpower", description="Show the overall power state")
    public String showPower() throws DriverException {
        return String.valueOf(this.ps.getPowerState());
    }

    @Command(name="showerrors", description="Show the error counters")
    public String showErrors() throws DriverException {
        return String.format("Seq: %s   Tmo: %s", this.ps.getNumSeqErr(), this.ps.getNumTimeout());
    }

    private String formatHex(int addr, int[] data) {
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < data.length; ++j) {
            if ((j & 3) == 0) {
                if (j > 0) {
                    text.append('\n');
                }
                text.append(String.format("%06x:", addr + j));
            }
            text.append(String.format(" %08x", data[j]));
        }
        return text.toString();
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

