/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.zonesui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.utilities.zonesui.ClickDialog;
import org.lsst.ccs.utilities.zonesui.ImageDescription;
import org.lsst.ccs.utilities.zonesui.InteractionProducer;
import org.lsst.ccs.utilities.zonesui.PositionListener;
import org.lsst.ccs.utilities.zonesui.Zone;

public class ImageZones
extends JPanel
implements MouseListener,
MouseMotionListener {
    private List<Zone> tableShape;
    private ImageDescription description;
    private ImageIcon icon;
    private Image img;
    private Dimension dim;
    private Stroke stroke = new BasicStroke(3.0f, 0, 0, 5.0f, new float[]{5.0f}, 0.0f);
    private Color color = Color.BLACK;
    private InteractionProducer interaction;
    private PositionListener posListener;
    private String message = "";
    int messageX = 0;
    int messageY = 0;

    public ImageZones(ImageDescription id, InteractionProducer ip, PositionListener posListener) {
        this.description = id;
        this.interaction = ip;
        this.posListener = posListener;
        this.icon = id.getIcon();
        this.tableShape = id.getShapeDescription();
        this.img = this.icon.getImage();
        this.dim = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim2 = new Dimension(this.icon.getIconWidth() / 2, this.icon.getIconHeight() / 2);
        return dim2;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.dim;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dim;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setDashedLineWidth(int points) {
        float width = points;
        this.setStroke(new BasicStroke(width, 0, 0, 5.0f, new float[]{5.0f}, 0.0f));
    }

    public Color getDashedLineColor() {
        return this.color;
    }

    public void setDashedLineColor(Color color) {
        this.color = color;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g2);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(this.img, 0, 0, this.img.getWidth(this), this.img.getHeight(this), this);
        g2.setColor(this.getDashedLineColor());
        g2.setStroke(this.getStroke());
        for (Zone zone : this.tableShape) {
            g2.draw(zone.getShape());
        }
        g2.setColor(Color.BLACK);
        this.messageY = g2.getFont().getSize();
        g2.drawString(this.message, this.messageX, this.messageY);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point pt = e.getPoint();
        for (Zone zone : this.tableShape) {
            if (!zone.getShape().contains(pt)) continue;
            String key = zone.getKey();
            JPanel jpan = this.interaction.getInteraction(key);
            if (jpan != null) {
                ClickDialog cd = new ClickDialog(SwingUtilities.windowForComponent(this), key, false, jpan);
                cd.setLocation(e.getXOnScreen(), e.getYOnScreen());
                break;
            }
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "JPanel not found for the key \"" + key + "\"", "JPanel error", 0);
            break;
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        Point pt = me.getPoint();
        String tooltipText = "";
        for (Zone zone : this.tableShape) {
            if (!zone.getShape().contains(pt)) continue;
            tooltipText = zone.getTipText();
            break;
        }
        this.setToolTipText(tooltipText);
        if (this.posListener != null) {
            this.posListener.currentCoords(me.getX(), me.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }
}

