package org.lsst.ccs.drivers.reb;

/**
 **********************************************************
 *
 *  Java interface to REBs connected via the DAQ0 system.
 *
 *  @author Owen Saxton
 *
 **********************************************************
 */
public class Daq0Client {

    static boolean first = true;

    static void loadLibrary() {
        if (first) {
            System.loadLibrary("RebDaq0");
            first = false;
        }
    }

   /**
    *  Register interface.
    */
    public static class Registers implements RegClient.Impl {

        Registers() {
            loadLibrary();
        }

        @Override
        public native long newRegClient(int id, String ifc);

        @Override
        public native void deleteRegClient(long handle);

        @Override
        public native int readReg(long handle, int address) throws REBException;

        @Override
        public native void readRegs(long handle, int address, int[] values,
                                    int offset, int count) throws REBException;

        @Override
        public native void writeReg(long handle, int address, int value) throws REBException;

        @Override
        public native void writeRegs(long handle, int address, int[] values,
                                     int offset, int count) throws REBException;

        @Override
        public native int updateReg(long handle, int address, int mask, int value)
            throws REBException;

    }

   /**
    *  Image interface.
    */
    public static class Images implements ImageClient.Impl  {

        long client, subscriber;

        Images() {
            loadLibrary();
            initSys();
        }

        private native static void initSys();

        @Override
        public native void newImageClient(int id, String ifc);

        @Override
        public native void deleteImageClient();

        @Override
        public native Image waitForImage(Image image);

        @Override
        public native boolean getImage(Image image);

        @Override
        public native void reset();

        @Override
        public native void deleteImageMetadataRef(Image image);

    }

   /**
    *  Global interface.
    */
    public static class Global implements GlobalClient.Impl  {
    }

}
