/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;

public class SlowAdcs {
    public static final int VERSION_WREB1 = 0;
    public static final int VERSION_WREB2 = 2;
    public static final int VERSION_REB3 = 1;
    public static final int VERSION_REB4 = 3;
    public static final int VERSION_GREB = 4;
    public static final int VERSION_REB5 = 5;
    public static final int REG_TEMP_SLCT = 0x600100;
    public static final int REG_TEMP_READ = 0x600101;
    public static final int REG_TEMP_MUX = 0x600200;
    public static final int TEMP_CABAC_TOP = 0;
    public static final int TEMP_CABAC_BOTTOM = 2;
    public static final int TEMP_ASPIC_TOP = 1;
    public static final int TEMP_ASPIC_BOTTOM = 3;
    public static final int NUM_TEMPS = 4;
    public static final int MUX_T_B_SLOW = 0;
    public static final int MUX_T_FAST_B_SLOW = 1;
    public static final int MUX_T_SLOW_B_FAST = 2;
    public static final int MUX_T_B_FAST = 3;
    public static final int NUM_MUX_SET = 4;
    public static final int REG_ASPIC_START = 0x600100;
    public static final int REG_ASPIC_READ = 0x601000;
    public static final int REG_MUX_CONFIG = 0x600101;
    public static final int REG_MUX_READ = 0x601010;
    public static final int NUM_CURR_CHANS = 8;
    public static final int REG_MON_START = 0xC00000;
    public static final int REG_MON_CONFIG = 0xC00001;
    public static final int REG_MON_READ = 0xC00010;
    public static final int OFF_MON_ADCS = 256;
    public static final int OFF_MON_OD = 0;
    public static final int OFF_MON_GD = 1;
    public static final int OFF_MON_OG = 2;
    public static final int OFF_MON_RD = 3;
    public static final int OFF_MON_CKP = 4;
    public static final int OFF_MON_CKS = 5;
    public static final int OFF_MON_RG = 6;
    public static final int OFF_MON_VREF25 = 7;
    public static final int OFF_MON_ODI_G = 7;
    public static final int OFF_MON_SCK_L = 0;
    public static final int OFF_MON_SCK_U = 1;
    public static final int OFF_MON_RG_L = 2;
    public static final int OFF_MON_RG_U = 3;
    public static final int OFF_MON_CKP_SH = 4;
    public static final int OFF_MON_V_DPHI = 4;
    public static final int OFF_MON_ODI_W = 5;
    public static final int OFF_MON_CK_SH = 5;
    public static final int OFF_MON_V_CLKL = 6;
    public static final int CHAN_OD_0 = 0;
    public static final int CHAN_OG_0 = 1;
    public static final int CHAN_RD_0 = 2;
    public static final int CHAN_GD_0 = 3;
    public static final int CHAN_OD_1 = 4;
    public static final int CHAN_OG_1 = 5;
    public static final int CHAN_RD_1 = 6;
    public static final int CHAN_GD_1 = 7;
    public static final int CHAN_OD_2 = 8;
    public static final int CHAN_OG_2 = 9;
    public static final int CHAN_RD_2 = 10;
    public static final int CHAN_GD_2 = 11;
    public static final int CHAN_VREF5_0 = 12;
    public static final int CHAN_VREF5_1 = 13;
    public static final int CHAN_VREF5_2 = 14;
    public static final int CHAN_VREF25_1 = 15;
    public static final int CHAN_OD = 0;
    public static final int CHAN_OG = 1;
    public static final int CHAN_RD = 2;
    public static final int CHAN_GD = 3;
    public static final int CHAN_VREF25 = 16;
    public static final int CHAN_CKP = 17;
    public static final int CHAN_CKS = 18;
    public static final int CHAN_RG = 19;
    public static final int CHAN_SCK_L = 20;
    public static final int CHAN_SCK_U = 21;
    public static final int CHAN_RG_L = 22;
    public static final int CHAN_RG_U = 23;
    public static final int CHAN_CKP_SH = 24;
    public static final int CHAN_ODI = 25;
    public static final int CHAN_CKP_L = 26;
    public static final int CHAN_CKP_U = 27;
    public static final int CHAN_VP12 = 28;
    public static final int CHAN_VN12 = 29;
    public static final int CHAN_V_DPHI = 30;
    public static final int CHAN_V_CLKL = 31;
    public static final int CHAN_CKP_0 = 17;
    public static final int CHAN_CKP_1 = 32;
    public static final int CHAN_CKS_0 = 18;
    public static final int CHAN_CKS_1 = 33;
    public static final int CHAN_RG_0 = 19;
    public static final int CHAN_RG_1 = 34;
    public static final int CHAN_ODI_0 = 25;
    public static final int CHAN_ODI_1 = 35;
    public static final int RANGE_PM10 = 1;
    public static final int RANGE_PM5 = 2;
    public static final int RANGE_PM2_5 = 3;
    public static final int RANGE_0_10 = 5;
    public static final int RANGE_0_5 = 6;
    public static final int ADC_0 = 0;
    public static final int ADC_1 = 1;
    public static final int ADC_2 = 2;
    public static final int SAM_0 = 0;
    public static final int SAM_1 = 1;
    public static final int SAM_2 = 2;
    public static final int SAM_3 = 3;
    public static final int SAM_4 = 4;
    public static final int SAM_5 = 5;
    public static final int SAM_6 = 6;
    public static final int SAM_7 = 7;
    public static final int BIAS_0 = 0;
    public static final int BIAS_1 = 1;
    public static final int BIAS_2 = 2;
    public static final int BIAS_3 = 3;
    public static final int BIAS_4 = 4;
    public static final int BIAS_5 = 5;
    public static final int BIAS_6 = 6;
    public static final int BIAS_7 = 7;
    public static final double VOLT_16_SCALE_WR = 2.288818359375E-5;
    public static final double VOLT_16_SCALE_GR = 1.25E-4;
    public static final double VOLT_12_SCALE = 0.001220703125;
    public static final double VOLT_12_SCALE_HI = 0.013427734375;
    public static final double VOLT_12_SCALE_R4 = 0.004884004884004884;
    public static final double VOLT_12_SCALE_M4 = 0.014652014652014652;
    public static final double VOLT_12_SCALE_H4 = 0.05372405372405373;
    public static final double VOLT_12_SCALE_R5 = 0.002442002442002442;
    public static final double VOLT_12_SCALE_M5 = 0.007326007326007326;
    public static final double VOLT_12_SCALE_H5 = 0.026862026862026864;
    public static final double VOLT_16_SCALE = 1.52587890625E-4;
    public static final double VOLT_16_SCALE_MD = 7.62939453125E-4;
    public static final double VOLT_16_SCALE_HI = 0.001678466796875;
    public static final double VOLT_16_SCALE_AG = 0.00107177734375;
    public static final double CURR_16_SCALE_OD = 2.5431315104166665E-6;
    public static final double CURR_12_SCALE = 1.220703125E-6;
    public static final double CURR_12_SCALE_R4 = 2.44140625E-6;
    public static final double TEMP_OFFSET = 442.32142857142856;
    public static final double TEMP_CONVN = -178.57142857142858;
    public static final double TEMP_16_SCALE_WR = -0.004087175641741072;
    public static final double TEMP_16_SCALE_GR = -0.022321428571428572;
    public static final double TEMP_12_SCALE = -0.21798270089285715;
    public static final double TEMP_12_SCALE_R4 = -0.4359654017857143;
    private static final int[] voltsCfgReb3 = new int[]{60, 92, 124, 28, 156, 220, 252, 29, 188, 61, 93, 157, 189, 221, 125, 253};
    private static final double[] voltsScaleReb3 = new double[]{0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125, 0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125, 0.001220703125, 0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125};
    private static final Map<Integer, Integer> chanMapReb3 = new HashMap<Integer, Integer>();
    private static final int[][] voltsCfgReb4;
    private static final double[] voltsScaleReb4;
    private static final Map<Integer, Integer> chanMapReb4;
    private static final double[] voltsScaleReb5;
    private static final double[][] voltsScaleWreb2;
    private static final Map<Integer, Integer> chanMapWreb2;
    private static final double[][] voltsScaleGreb;
    private static final Map<Integer, Integer> chanMapGreb;
    private static final Map<Integer, Map> chanMapMap;
    private static final Map<Integer, double[][]> voltsScaleMap;
    long aspicTime;
    BaseSet bss;

    public SlowAdcs(BaseSet bss) {
        this.bss = bss;
    }

    public synchronized int readDirect(int config) throws REBException {
        this.bss.checkVersion(11, 1, 3, 5);
        this.bss.write(0x600101, config);
        return this.bss.read(0x601010) & 0xFFFF;
    }

    public synchronized double[] readAspicTemps(int first, int count) throws REBException {
        int version = this.bss.getVersion(11);
        if (first < 0 || count < 0 || first + count > this.getNumAspicTemps()) {
            throw new REBException("Invalid ASPIC temperature range");
        }
        double[] data = new double[count];
        if (version == 0 || version == 2) {
            for (int j = 0; j < count; ++j) {
                data[j] = this.readWrebAspicTemp(first + j);
            }
        } else if (version == 4) {
            for (int j = 0; j < count; ++j) {
                int index = first + j;
                data[j] = this.readGrebAspicTemp(index / 2, index & 1);
            }
        } else {
            double scale = version == 3 ? -0.4359654017857143 : -0.21798270089285715;
            this.bss.write(0x600100, 0);
            for (int j = 0; j < count; ++j) {
                int value = this.bss.read(0x601000 + first + j);
                data[j] = 442.32142857142856 + scale * (double)(value & 0xFFF);
            }
        }
        return data;
    }

    public synchronized double readAspicTemp(int strip, int side) throws REBException {
        double scale;
        int version = this.bss.getVersion(11);
        this.checkStrip(strip, version);
        SlowAdcs.checkSide(side);
        if (version == 0 || version == 2) {
            return this.readWrebAspicTemp(side);
        }
        if (version == 4) {
            return this.readGrebAspicTemp(strip, side);
        }
        if (version == 1) {
            this.bss.write(0x600101, 4 * strip + side + 2);
            scale = -0.21798270089285715;
        } else {
            int samChan = 4 * strip + side + 2;
            this.setMuxReb4(0, samChan & 7, samChan >> 3, 6);
            scale = version == 3 ? -0.4359654017857143 : -0.21798270089285715;
        }
        return 442.32142857142856 + (double)(this.bss.read(0x601010) & 0xFFF) * scale;
    }

    private double readWrebAspicTemp(int side) throws REBException {
        long wait = this.aspicTime + 150L - System.currentTimeMillis();
        if (wait > 0L) {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.bss.write(0x600100, 1 + 2 * side);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.aspicTime = System.currentTimeMillis();
        int value = (this.bss.read(0x600101) ^ 0x800000) << 8 >> 14;
        return 442.32142857142856 + (double)(value + 131072) * -0.004087175641741072;
    }

    private double readGrebAspicTemp(int strip, int side) throws REBException {
        this.bss.write(0x600100, strip);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int value = this.bss.read(0x600101 + side);
        return 442.32142857142856 + (double)(value >> 16) * -0.022321428571428572;
    }

    public synchronized double readVoltage(int chan) throws REBException {
        int version = this.bss.getVersion(11);
        Map chanMap = chanMapMap.get(version);
        if (chanMap == null) {
            throw new REBException("Unsupported firmware version");
        }
        Integer desc = (Integer)chanMap.get(chan);
        if (desc == null) {
            throw new REBException("Invalid voltage channel: " + chan);
        }
        if (version == 1) {
            this.bss.write(0x600101, voltsCfgReb3[desc]);
            return (double)(this.bss.read(0x601010) & 0xFFF) * voltsScaleReb3[desc];
        }
        if (version == 3 || version == 5) {
            int[] cfg = voltsCfgReb4[desc];
            this.setMuxReb4(cfg[0], cfg[1], cfg[2], cfg[3]);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int offset = cfg[3] >= 5 ? 0 : 2048;
            double[] voltsScale = version == 3 ? voltsScaleReb4 : voltsScaleReb5;
            return (double)((this.bss.read(0x601010) & 0xFFF) - offset) * voltsScale[desc];
        }
        int adc = desc >> 4;
        int ch = desc & 0xF;
        int rawValue = this.bss.read(0xC00010 + adc * 256 + ch) & 0xFFFF;
        return (double)(rawValue - 32768) * voltsScaleMap.get(version)[adc][ch];
    }

    public synchronized double readVoltageNow(int chan) throws REBException {
        int version = this.bss.getVersion(11);
        if (version == 2 || version == 4) {
            Integer desc = (Integer)chanMapMap.get(version).get(chan);
            if (desc == null) {
                throw new REBException("Invalid voltage channel: " + chan);
            }
            this.fetchVoltages(1 << (desc >> 4));
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.readVoltage(chan);
    }

    public synchronized double readCurrent(int strip, int side, int chan) throws REBException {
        double scale;
        this.bss.checkVersion(11, 1, 3, 5);
        int version = this.bss.getVersion(11);
        this.checkStrip(strip, version);
        SlowAdcs.checkSide(side);
        if (chan < 0 || chan >= 8) {
            throw new REBException("Invalid current channel: " + chan);
        }
        if (version == 1) {
            this.bss.write(0x600101, 4 * strip + side | chan << 5 | 0x10);
            scale = 1.220703125E-6;
        } else {
            int samChan = 4 * strip + side;
            this.setMuxReb4(chan, samChan & 7, samChan >> 3, 6);
            scale = version == 3 ? 2.44140625E-6 : 1.220703125E-6;
        }
        return (double)(this.bss.read(0x601010) & 0xFFF) * scale;
    }

    public double readCurrent(int chan) throws REBException {
        return this.readCurrent(chan >> 4, chan >> 3 & 1, chan & 7);
    }

    public void fetchVoltages(int mask) throws REBException {
        this.bss.checkVersion(11, 2, 4);
        if (this.bss.getVersion(11) == 2) {
            for (int j = 0; j <= this.bss.getNumStrips(); ++j) {
                if ((mask & 1 << j) == 0) continue;
                this.bss.write(0xC00000 + j * 256, 0);
            }
        } else {
            this.bss.write(0xC00000, 0);
        }
    }

    public void fetchVoltages() throws REBException {
        this.fetchVoltages((1 << this.bss.getNumStrips() + 1) - 1);
    }

    public void configure(int adc, int value) throws REBException {
        this.bss.checkVersion(11, 2, 4);
        this.checkAdc(adc);
        if (this.bss.getVersion(11) == 2) {
            this.bss.write(0xC00001 + adc * 256, value & 0xF);
        } else {
            this.bss.write(0xC00001, adc << 4 | value & 0xF);
        }
    }

    public synchronized double readSlow(int chan) throws REBException {
        this.bss.checkVersion(11, 0, 2);
        if (chan < 0 || chan >= 4) {
            throw new REBException("Invalid slow ADC channel number");
        }
        this.bss.write(0x600100, chan);
        int value = (this.bss.read(0x600101) ^ 0x800000) << 8 >> 14;
        return 2.288818359375E-5 * (double)value;
    }

    public void setMux(int set) throws REBException {
        this.bss.checkVersion(11, 0);
        if (set < 0 || set >= 4) {
            throw new REBException("Invalid MUX setting value: " + set);
        }
        this.bss.write(0x600200, set);
    }

    public int getNumAspicTemps() throws REBException {
        return 2 * this.bss.getNumStrips();
    }

    public int getNumCcdCurrents() throws REBException {
        return this.bss.isVersion(11, 1, 3, 5) ? 16 * this.bss.getNumStrips() : 0;
    }

    public boolean testChannel(int chan) {
        try {
            Map chanMap = chanMapMap.get(this.bss.getVersion(11));
            return chanMap != null && chanMap.get(chan) != null;
        }
        catch (REBException e) {
            return false;
        }
    }

    private void setMuxReb4(int bias, int sam, int adc, int range) throws REBException {
        this.bss.write(0x600101, sam << 19 | bias << 16 | 0x800 | adc << 5 | range << 1);
    }

    private void checkStrip(int strip, int version) throws REBException {
        if (strip < 0 || strip >= this.bss.getNumStrips()) {
            throw new REBException("Invalid strip number: " + strip);
        }
    }

    private static void checkSide(int side) throws REBException {
        if (side < 0 || side >= 2) {
            throw new REBException("Invalid board side: " + side);
        }
    }

    private void checkAdc(int adc) throws REBException {
        if (adc < 0 || adc > this.bss.getNumStrips()) {
            throw new REBException("Invalid ADC number: " + adc);
        }
    }

    static {
        chanMapReb3.put(0, 0);
        chanMapReb3.put(1, 1);
        chanMapReb3.put(2, 2);
        chanMapReb3.put(3, 3);
        chanMapReb3.put(12, 4);
        chanMapReb3.put(4, 5);
        chanMapReb3.put(5, 6);
        chanMapReb3.put(6, 7);
        chanMapReb3.put(7, 8);
        chanMapReb3.put(13, 9);
        chanMapReb3.put(15, 10);
        chanMapReb3.put(8, 11);
        chanMapReb3.put(9, 12);
        chanMapReb3.put(10, 13);
        chanMapReb3.put(11, 14);
        chanMapReb3.put(14, 15);
        voltsCfgReb4 = new int[][]{{1, 4, 1, 2}, {2, 4, 1, 2}, {3, 4, 1, 2}, {0, 4, 1, 2}, {4, 4, 1, 2}, {6, 4, 1, 2}, {7, 4, 1, 2}, {0, 5, 1, 2}, {5, 4, 1, 2}, {1, 5, 1, 2}, {2, 5, 1, 2}, {4, 5, 1, 2}, {5, 5, 1, 2}, {6, 5, 1, 2}, {3, 5, 1, 2}, {7, 5, 1, 2}, {0, 0, 2, 2}, {0, 1, 2, 2}, {0, 2, 2, 2}, {0, 3, 2, 2}, {0, 4, 2, 2}, {0, 5, 2, 2}, {0, 6, 2, 2}, {0, 7, 2, 2}};
        voltsScaleReb4 = new double[]{0.05372405372405373, 0.014652014652014652, 0.05372405372405373, 0.05372405372405373, 0.004884004884004884, 0.05372405372405373, 0.014652014652014652, 0.05372405372405373, 0.05372405372405373, 0.004884004884004884, 0.004884004884004884, 0.05372405372405373, 0.014652014652014652, 0.05372405372405373, 0.05372405372405373, 0.004884004884004884, 0.014652014652014652, 0.014652014652014652, 0.014652014652014652, 0.014652014652014652, 0.014652014652014652, 0.014652014652014652, 0.014652014652014652, 0.014652014652014652};
        chanMapReb4 = new HashMap<Integer, Integer>();
        chanMapReb4.put(0, 0);
        chanMapReb4.put(1, 1);
        chanMapReb4.put(2, 2);
        chanMapReb4.put(3, 3);
        chanMapReb4.put(12, 4);
        chanMapReb4.put(4, 5);
        chanMapReb4.put(5, 6);
        chanMapReb4.put(6, 7);
        chanMapReb4.put(7, 8);
        chanMapReb4.put(13, 9);
        chanMapReb4.put(15, 10);
        chanMapReb4.put(8, 11);
        chanMapReb4.put(9, 12);
        chanMapReb4.put(10, 13);
        chanMapReb4.put(11, 14);
        chanMapReb4.put(14, 15);
        chanMapReb4.put(27, 16);
        chanMapReb4.put(26, 17);
        chanMapReb4.put(21, 18);
        chanMapReb4.put(20, 19);
        chanMapReb4.put(23, 20);
        chanMapReb4.put(22, 21);
        chanMapReb4.put(28, 22);
        chanMapReb4.put(29, 23);
        voltsScaleReb5 = new double[]{0.026862026862026864, 0.007326007326007326, 0.026862026862026864, 0.026862026862026864, 0.002442002442002442, 0.026862026862026864, 0.007326007326007326, 0.026862026862026864, 0.026862026862026864, 0.002442002442002442, 0.002442002442002442, 0.026862026862026864, 0.007326007326007326, 0.026862026862026864, 0.026862026862026864, 0.002442002442002442, 0.007326007326007326, 0.007326007326007326, 0.007326007326007326, 0.007326007326007326, 0.007326007326007326, 0.007326007326007326, 0.007326007326007326, 0.007326007326007326};
        voltsScaleWreb2 = new double[][]{{0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 1.52587890625E-4}, {7.62939453125E-4, 7.62939453125E-4, 7.62939453125E-4, 7.62939453125E-4, 7.62939453125E-4, 2.5431315104166665E-6}};
        chanMapWreb2 = new HashMap<Integer, Integer>();
        chanMapWreb2.put(0, 0);
        chanMapWreb2.put(3, 1);
        chanMapWreb2.put(1, 2);
        chanMapWreb2.put(2, 3);
        chanMapWreb2.put(17, 4);
        chanMapWreb2.put(18, 5);
        chanMapWreb2.put(19, 6);
        chanMapWreb2.put(16, 7);
        chanMapWreb2.put(20, 16);
        chanMapWreb2.put(21, 17);
        chanMapWreb2.put(22, 18);
        chanMapWreb2.put(23, 19);
        chanMapWreb2.put(24, 20);
        chanMapWreb2.put(25, 21);
        voltsScaleGreb = new double[][]{{0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375}, {0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 2.5431315104166665E-6}, {0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 0.00107177734375, 2.5431315104166665E-6}};
        chanMapGreb = new HashMap<Integer, Integer>();
        chanMapGreb.put(20, 0);
        chanMapGreb.put(21, 1);
        chanMapGreb.put(22, 2);
        chanMapGreb.put(23, 3);
        chanMapGreb.put(24, 5);
        chanMapGreb.put(30, 4);
        chanMapGreb.put(31, 6);
        chanMapGreb.put(0, 16);
        chanMapGreb.put(3, 17);
        chanMapGreb.put(1, 18);
        chanMapGreb.put(2, 19);
        chanMapGreb.put(17, 20);
        chanMapGreb.put(18, 21);
        chanMapGreb.put(19, 22);
        chanMapGreb.put(25, 23);
        chanMapGreb.put(4, 32);
        chanMapGreb.put(7, 33);
        chanMapGreb.put(5, 34);
        chanMapGreb.put(6, 35);
        chanMapGreb.put(32, 36);
        chanMapGreb.put(33, 37);
        chanMapGreb.put(34, 38);
        chanMapGreb.put(35, 39);
        chanMapMap = new HashMap<Integer, Map>();
        chanMapMap.put(1, chanMapReb3);
        chanMapMap.put(3, chanMapReb4);
        chanMapMap.put(5, chanMapReb4);
        chanMapMap.put(2, chanMapWreb2);
        chanMapMap.put(4, chanMapGreb);
        voltsScaleMap = new HashMap<Integer, double[][]>();
        voltsScaleMap.put(2, voltsScaleWreb2);
        voltsScaleMap.put(4, voltsScaleGreb);
    }
}

