/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class ImageClient {
    public static final int HDW_TYPE_DAQ0 = 0;
    public static final int HDW_TYPE_DAQ1 = 1;
    public static final int HDW_TYPE_PCI = 2;
    private static final int RUNNING = 0;
    private static final int CLOSING = 1;
    private static final int ENDING = 2;
    private ReadThread reader;
    private Listener imgListener;
    private Image listenImage;
    private Impl impl;
    private final RegClient reg;
    private ClientFactory clientFactory = new ClientFactory();

    public ImageClient() {
        this(null);
    }

    public ImageClient(RegClient reg) {
        this.reg = reg;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.impl != null) {
            this.impl.deleteImageClient();
        }
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Deprecated
    public void open(int id) throws REBException {
        this.open(id, null);
    }

    @Deprecated
    public void open(int id, String ifc) throws REBException {
        this.open(0, id, ifc);
    }

    public void open(int hdw, int id, String ifc) throws REBException {
        if (this.impl != null) {
            throw new REBException("Image connection already open");
        }
        this.impl = this.clientFactory.createImageClient(hdw, this.reg);
        this.impl.newImageClient(id, ifc);
        if (this.imgListener != null) {
            this.reader = new ReadThread(this.imgListener, this.listenImage);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public void close() throws REBException {
        this.checkOpen();
        if (this.reader != null) {
            this.reader.setState(2);
        }
        this.impl.deleteImageClient();
        if (this.reader != null) {
            try {
                this.reader.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reader = null;
        }
        this.impl = null;
    }

    public Image awaitImage(Image image) throws REBException {
        this.checkOpen();
        return this.impl.waitForImage(image);
    }

    public boolean readImage(Image image) throws REBException {
        this.checkOpen();
        return this.impl.getImage(image);
    }

    public void deleteImageMetadataRef(Image image) {
        this.impl.deleteImageMetadataRef(image);
    }

    public void resetFrontEnd() throws REBException {
        this.checkOpen();
        this.impl.reset();
    }

    public void setListener(Listener listener, Image image) {
        this.clearListener();
        this.imgListener = listener;
        this.listenImage = image;
        if (this.impl != null) {
            this.reader = new ReadThread(listener, image);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public void clearListener() {
        if (this.reader != null) {
            this.reader.setState(2);
            this.reader = null;
        }
        this.imgListener = null;
        this.listenImage = null;
    }

    private void checkOpen() throws REBException {
        if (this.impl == null) {
            throw new REBException("Image connection not open");
        }
    }

    public static interface Impl {
        public void newImageClient(int var1, String var2) throws REBException;

        public void deleteImageClient();

        public Image waitForImage(Image var1);

        public boolean getImage(Image var1);

        public void reset();

        public void deleteImageMetadataRef(Image var1);
    }

    public class ReadThread
    extends Thread {
        Listener listener;
        Image listenImage;
        int state = 0;

        public ReadThread(Listener lstnr, Image image) {
            this.listener = lstnr;
            this.listenImage = image;
        }

        @Override
        public void run() {
            while (this.state == 0) {
                Image image = ImageClient.this.impl.waitForImage(this.listenImage);
                if (this.state != 0) break;
                if (!ImageClient.this.impl.getImage(image)) continue;
                Listener l = this.listener;
                if (this.state != 0) break;
                l.processImage(image);
            }
            if (this.state == 1) {
                ImageClient.this.impl.deleteImageClient();
            }
        }

        public void setState(int newState) {
            this.state = newState;
        }
    }

    public static interface Listener {
        public void processImage(Image var1);
    }
}

