package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Java interfaces to REBs connected via the DAQ v1 system.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class Daq1Client {

    static boolean first = true;

    static void loadLibrary() {
        if (first) {
            System.loadLibrary("RebDaq1");
            first = false;
        }
    }

   /**
     **************************************************************************
     **
     **  Register interface.
     **
     **************************************************************************
     */
    public static class Registers implements RegClient.Impl {

        int id;

        Registers() {
            loadLibrary();
        }

        @Override
        public long newRegClient(int id, String ifc) {
            // FIXME: Storing the id as a member variable looks somewhat dubious
            // What if newRegClient is called more than once on the same instance
            // of RegClientDaq1?
            this.id = id;
            return newRegClient1(id);
        }

        private native long newRegClient1(int id);

        @Override
        public native void deleteRegClient(long handle);

        @Override
        public synchronized int readReg(long handle, int address)
            throws REBException {
            int[] values = new int[1];
            readRegs1(handle, id, address, values, 0, 1);
            return values[0];
        }

        @Override
        public synchronized void readRegs(long handle, int address, int[] values,
                                          int offset, int count)
            throws REBException {
            readRegs1(handle, id, address, values, offset, count);
        }

        private native void readRegs1(long handle, int id, int address, int[] values,
                                      int offset, int count) throws REBException;

        @Override
        public synchronized void writeReg(long handle, int address, int value)
            throws REBException {
            int[] values = {value};
            writeRegs1(handle, id, address, values, 0, 1);
        }

        @Override
        public synchronized void writeRegs(long handle, int address, int[] values,
                                           int offset, int count)
            throws REBException {
            writeRegs1(handle, id, address, values, offset, count);
        }

        private native void writeRegs1(long handle, int id, int address,
                                       int[] values, int offset, int count)
            throws REBException;

        @Override
        public synchronized int updateReg(long handle, int address, int mask,
                                          int value) throws REBException {
            /*
            updateReg1(handle, id, address, mask, value);
            return 0;
            */
            int[] values = {0};
            readRegs1(handle, id, address, values, 0, 1);
            int oldVal = values[0];
            values[0] = (values[0] & ~mask) | (value & mask);
            writeRegs1(handle, id, address, values, 0, 1);
            return oldVal;
        }

        private native void updateReg1(long handle, int id, int address, int mask,
                                       int value) throws REBException;

    }

   /**
     **************************************************************************
     **
     **  Image interface.
     **
     **************************************************************************
     */
    public static class Images implements ImageClient.Impl  {

        long handle;

        Images() {
            loadLibrary();
            initSys();
        }

        private native static void initSys();

        @Override
        public void newImageClient(int id, String ifc) {
            this.handle = newImageClient1(id);
        }

        private native long newImageClient1(int id);

        @Override
        public void deleteImageClient() {
            deleteImageClient1(handle);
        }

        private native void deleteImageClient1(long handle);

        @Override
        public Image waitForImage(Image image) {
            return waitForImage1(handle, image);
        }

        private native Image waitForImage1(long handle, Image image);
        
        @Override
        public native boolean getImage(Image image);

        @Override
        public void reset() {
            reset1(handle);
        }

        private native void reset1(long handle);

        @Override
        public native void deleteImageMetadataRef(Image image);

    }

   /**
     **************************************************************************
     **
     **  Global interface.
     **
     **************************************************************************
     */
    public static class Global implements GlobalClient.Impl  {

        long system;

        Global() {
            loadLibrary();
            initSys();
        }

        private native static void initSys();

        @Override
        public native void newGlobalClient(int[] ids, String ifc);

        @Override
        public native void deleteGlobalClient();

        @Override
        public native void triggerImage(String name);

    }

}
