/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.TestReg;

public class TestAD7794
extends BaseSet {
    private static final Map<Integer, String> chanValues = new HashMap<Integer, String>();
    private static final Map<Integer, String> cnvModeValues;
    private static final Map<Integer, String> rateValues;
    private static final Map<Integer, String> clockValues;
    private static final Map<Integer, String> gainValues;
    private static final Map<Integer, String> refsValues;
    private static final Map<Integer, String> calibValues;
    int rebId = -1;
    private static final String[] regName;
    private static final String[] regDesc0;
    private static final String[] regDesc1;
    public static final int REG_RTD_COMMAND = 0x700000;
    public static final int REG_RTD_REPLY = 0x700001;
    public static final int REG_RTD_RESET = 0x700002;
    public static final int CMND_READ = 524288;
    public static final int NUM_RTD_TEMPS = 4;
    public static final int STATUS_REG = 0;
    public static final int MODE_REG = 1;
    public static final int CONFIG_REG = 2;
    public static final int DATA_REG = 3;
    public static final int ID_REG = 4;
    public static final int IO_REG = 5;
    public static final int OFFSET_REG = 6;
    public static final int SCALE_REG = 7;
    public static final int COM_READ = 64;
    public static final int COM_ADDRESS_M = 56;
    public static final int COM_ADDRESS_V = 3;
    public static final int COM_CONT_READ = 4;
    public static final int STS_READY = 128;
    public static final int STS_ERROR = 64;
    public static final int STS_NOXREF = 32;
    public static final int STS_AD7794 = 8;
    public static final int STS_CHANNEL_M = 7;
    public static final int STS_CHANNEL_V = 0;
    public static final int MOD_MODE_M = 57344;
    public static final int MOD_MODE_V = 13;
    public static final int MODE_CONT = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_IDLE = 2;
    public static final int MODE_PWR_DOWN = 3;
    public static final int MODE_INT_Z_CAL = 4;
    public static final int MODE_INT_F_CAL = 5;
    public static final int MODE_SYS_Z_CAL = 6;
    public static final int MODE_SYS_F_CAL = 7;
    public static final int MOD_PSW = 4096;
    public static final int MOD_AMP_CM = 512;
    public static final int MOD_CLOCK_M = 192;
    public static final int MOD_CLOCK_V = 6;
    public static final int CLOCK_INT = 0;
    public static final int CLOCK_INT_AVL = 1;
    public static final int CLOCK_EXT = 2;
    public static final int CLOCK_EXT_HALF = 3;
    public static final int MOD_CHOP_DIS = 16;
    public static final int MOD_FRS_M = 15;
    public static final int MOD_FRS_V = 0;
    public static final int FRS_RATE_470 = 1;
    public static final int FRS_RATE_242 = 2;
    public static final int FRS_RATE_123 = 3;
    public static final int FRS_RATE_62 = 4;
    public static final int FRS_RATE_50 = 5;
    public static final int FRS_RATE_39 = 6;
    public static final int FRS_RATE_33 = 7;
    public static final int FRS_RATE_19 = 8;
    public static final int FRS_RATE_17 = 9;
    public static final int FRS_RATE_16 = 10;
    public static final int FRS_RATE_12 = 11;
    public static final int FRS_RATE_10 = 12;
    public static final int FRS_RATE_8 = 13;
    public static final int FRS_RATE_6 = 14;
    public static final int FRS_RATE_4 = 15;
    public static final int MOD_STANDARD = 10;
    public static final int CFG_VBIAS_M = 49152;
    public static final int CFG_VBIAS_V = 14;
    public static final int VBIAS_OFF = 0;
    public static final int VBIAS_AIN1 = 1;
    public static final int VBIAS_AIN2 = 2;
    public static final int VBIAS_AIN3 = 3;
    public static final int CFG_BURNOUT = 8192;
    public static final int CFG_UNIPOLAR = 4096;
    public static final int CFG_BOOST = 2048;
    public static final int CFG_GAIN_M = 1792;
    public static final int CFG_GAIN_V = 8;
    public static final int GAIN_1 = 0;
    public static final int GAIN_2 = 1;
    public static final int GAIN_4 = 2;
    public static final int GAIN_8 = 3;
    public static final int GAIN_16 = 4;
    public static final int GAIN_32 = 5;
    public static final int GAIN_64 = 6;
    public static final int GAIN_128 = 7;
    public static final int RANGE_2500 = 0;
    public static final int RANGE_1250 = 1;
    public static final int RANGE_625 = 2;
    public static final int RANGE_312 = 3;
    public static final int RANGE_156 = 4;
    public static final int RANGE_78 = 5;
    public static final int RANGE_39 = 6;
    public static final int RANGE_19 = 7;
    public static final int CFG_REFSEL_M = 192;
    public static final int CFG_REFSEL_V = 6;
    public static final int REFSEL_EXT1 = 0;
    public static final int REFSEL_EXT2 = 1;
    public static final int REFSEL_INT = 2;
    public static final int CFG_REF_DETECT = 32;
    public static final int CFG_BUFFERED = 16;
    public static final int CFG_CHANNEL_M = 15;
    public static final int CFG_CHANNEL_V = 0;
    public static final int CHAN_AIN1 = 0;
    public static final int CHAN_AIN2 = 1;
    public static final int CHAN_AIN3 = 2;
    public static final int CHAN_AIN4 = 3;
    public static final int CHAN_AIN5 = 4;
    public static final int CHAN_AIN6 = 5;
    public static final int CHAN_TEMP = 6;
    public static final int CHAN_VDD = 7;
    public static final int CHAN_AIN1A = 8;
    public static final int CFG_STANDARD = 1808;
    public static final int IO_DIOENA = 64;
    public static final int IO_IO2DAT = 32;
    public static final int IO_IO1DAT = 16;
    public static final int IO_IEXCDIR_M = 12;
    public static final int IO_IEXCDIR_V = 2;
    public static final int IEXCDIR_12 = 0;
    public static final int IEXCDIR_21 = 1;
    public static final int IEXCDIR_11 = 2;
    public static final int IEXCDIR_22 = 3;
    public static final int IO_IEXCENA_M = 3;
    public static final int IO_IEXCENA_V = 0;
    public static final int IEXCENA_OFF = 0;
    public static final int IEXCENA_10 = 1;
    public static final int IEXCENA_210 = 2;
    public static final int IEXCENA_1000 = 3;
    public static final int IO_STANDARD = 0;
    public static final int OPTN_CONFIG = 1;
    public static final int OPTN_SINGLE = 2;
    public static final int OPTN_IMMED = 4;
    public static final int DIO_ENABLE = 1;
    public static final int DIO_P1DATA = 2;
    public static final int DIO_P2DATA = 4;
    public static final int CAL_INT_ZERO = 0;
    public static final int CAL_INT_FULL = 1;
    public static final int CAL_SYS_ZERO = 2;
    public static final int CAL_SYS_FULL = 3;
    private static final int[] REG_SIZE;
    private static final double HALF_RANGE = 8388608.0;
    private static final double REF_VOLTAGE = 1.17;
    private static final double INT_TEMP_SCALE = 100.0;
    private static final double INT_VOLT_SCALE = 6.0;
    private boolean debug;
    private int readDelay;
    private int writeDelay;

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="type", description="Hardware type") TestReg.HdwType type, @Argument(name="id", description="REB ID") int id, @Argument(name="ifcname", description="Network interface name") String ifcName) throws REBException {
        this.rebId = id;
        this.open(type.getValue(), this.rebId, ifcName);
    }

    @Command(name="disconnect", description="Disconnect from a REB")
    public void disconnect() throws REBException {
        this.close();
        this.rebId = -1;
    }

    @Command(name="initialize", description="Initialize the chip")
    public void initialize() throws REBException {
        this.reset();
        this.setupStandard();
    }

    @Command(name="showstatus", description="Show the status register")
    public String showStatReg() throws REBException {
        int status = this.getStatus();
        return String.format("Status: %sready, %serror, %sextref, %s, chan = %s", (status & 0x80) == 0 ? "" : "not ", (status & 0x40) != 0 ? "" : "no ", (status & 0x20) == 0 ? "" : "no ", (status & 8) != 0 ? "AD7794" : "AD7795", chanValues.get(status & 7));
    }

    @Command(name="setchannel", description="Set the channel")
    public void setChan(@Argument(name="chan", description="Channel name") ChanNames chan) throws REBException {
        this.setChannel(chan.getValue());
    }

    @Command(name="showchannel", description="Show the channel")
    public String showChan() throws REBException {
        int chan = this.getChannel();
        return String.format("Channel = %s (%s)", chan, chanValues.get(chan));
    }

    @Command(name="setconversion", description="Set the conversion mode")
    public void setConv(@Argument(name="mode", description="Conversion mode") CnvModeNames mode) throws REBException {
        this.setConvMode(mode.getValue());
    }

    @Command(name="showconversion", description="Show the conversion mode")
    public String showConv() throws REBException {
        int mode = this.getConvMode();
        return String.format("Conversion mode = %s (%s)", mode, cnvModeValues.get(mode));
    }

    @Command(name="setrate", description="Set the conversion rate")
    public void setRate(@Argument(name="rate", description="Conversion rate") RateNames rate) throws REBException {
        this.setConvRate(rate.getValue());
    }

    @Command(name="showrate", description="Show the conversion rate")
    public String showRate() throws REBException {
        int rate = this.getConvRate();
        return String.format("Conversion rate = %s (%s)", rate, rateValues.get(rate).substring(1) + " Hz");
    }

    @Command(name="setclock", description="Set the clock source")
    public void setClock(@Argument(name="clock", description="Clock source") ClockNames clock) throws REBException {
        this.setClockSource(clock.getValue());
    }

    @Command(name="showclock", description="Show the clock source")
    public String showClock() throws REBException {
        int clock = this.getClockSource();
        return String.format("Clock source = %s (%s)", clock, clockValues.get(clock));
    }

    @Command(name="setgain", description="Set the gain")
    public void setGain(@Argument(name="gain", description="The gain name") GainNames gain) throws REBException {
        this.setGain(gain.getValue());
    }

    @Command(name="showgain", description="Show the gain")
    public String showGain() throws REBException {
        int gain = this.getGain();
        return String.format("ADC gain = %s (%sx)", gain, gainValues.get(gain).substring(1));
    }

    @Command(name="setreference", description="Set the reference source")
    public void setReference(@Argument(name="source", description="Reference source") RefsNames source) throws REBException {
        this.setRefSelect(source.getValue());
    }

    @Command(name="showreference", description="Show the reference source")
    public String showRefsel() throws REBException {
        int refs = this.getRefSelect();
        return String.format("Reference source = %s (%s)", refs, refsValues.get(refs));
    }

    @Command(name="setrefdet", description="Set reference detection")
    public void setRefdet(@Argument(name="state", description="State to set") TestReg.OnOff det) throws REBException {
        this.setRefDetect(det == TestReg.OnOff.ON);
    }

    @Command(name="showrefdet", description="Show reference detection state")
    public String showRefdet() throws REBException {
        return String.format("Reference detection is %s", TestAD7794.onOff(this.isRefDetect()));
    }

    @Command(name="setbuffered", description="Set buffered mode state")
    public void setBuff(@Argument(name="state", description="State to set") TestReg.OnOff on) throws REBException {
        this.setBuffered(on == TestReg.OnOff.ON);
    }

    @Command(name="showbuffered", description="Show buffered mode state")
    public String showBuff() throws REBException {
        return String.format("Buffered mode is %s", TestAD7794.onOff(this.isBuffered()));
    }

    @Command(name="setunipolar", description="Set unipolar state")
    public void setUnipol(@Argument(name="state", description="State to set") TestReg.OnOff on) throws REBException {
        this.setUnipolar(on == TestReg.OnOff.ON);
    }

    @Command(name="showunipolar", description="Shoe unipolar state")
    public String showUnipol() throws REBException {
        return String.format("Unipolar mode is %s", TestAD7794.onOff(this.isUnipolar()));
    }

    @Command(name="setswitch", description="Set the power switch")
    public void setSwitch(@Argument(name="state", description="Switch state") TestReg.OnOff on) throws REBException {
        this.setPowerSwitch(on == TestReg.OnOff.ON);
    }

    @Command(name="showswitch", description="Show the power switch")
    public String showSwitch() throws REBException {
        return String.format("Power switch is %s", TestAD7794.onOff(this.isPowerSwitch()));
    }

    @Command(name="readadc", description="Read an ADC")
    public String readAdc(@Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Sample count") int count, OptionNames ... optns) throws REBException {
        int option = this.getOption(optns);
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.readAdc(chan, option);
            sum += value;
            sumsq += value * value;
        }
        return TestAD7794.showStats("Raw " + chanValues.get(chan), count, sum, sumsq);
    }

    @Command(name="readtemp", description="Read the chip temperature")
    public String readTemp(@Argument(name="count", description="Sample count") int count, OptionNames ... optns) throws REBException {
        int option = this.getOption(optns);
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.readTemperature(option);
            sum += value;
            sumsq += value * value;
        }
        return TestAD7794.showStats("Temperature", count, sum, sumsq);
    }

    @Command(name="readvdd", description="Read the chip VDD")
    public String ReadVdd(@Argument(name="count", description="Sample count") int count, OptionNames ... optns) throws REBException {
        int option = this.getOption(optns);
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.readVdd(option);
            sum += value;
            sumsq += value * value;
        }
        return TestAD7794.showStats("Voltage", count, sum, sumsq);
    }

    @Command(name="calibrate", description="Perform a calibration")
    public String calib(@Argument(name="chan", description="Channel number") int chan, @Argument(name="type", description="Calibration type") int type) throws REBException {
        int value = this.calibrate(chan, type);
        return String.format("New %s value = %s", (type & 1) == 0 ? "offset" : "scale", value);
    }

    @Command(name="showcalib", description="Show calibration values")
    public String showCalib(@Argument(name="chan", description="Channel number") int chan) throws REBException {
        int[] value = this.getCalibration(chan);
        return String.format("Offset = %s, scale = %s", value[0], value[1]);
    }

    @Command(name="showregs", description="Show all register values")
    public String showRegs() throws REBException {
        StringBuilder st = new StringBuilder();
        int[] regSize = this.getRegSizes();
        for (int j = 0; j < 8; ++j) {
            int value = this.readRegister(j);
            int size = 2 * regSize[j];
            String fmt = String.format("%%d (%%s): %%s%%0%sx  %%s", size);
            if (j > 0) {
                st.append('\n');
            }
            st.append(String.format(fmt, j, regName[j], "      ".substring(size), value, regDesc0[j]));
            if (regDesc1[j].isEmpty()) continue;
            st.append(String.format("\n                  %s", regDesc1[j]));
        }
        return st.toString();
    }

    @Command(name="readregister", description="Read a register")
    public String readReg(@Argument(name="regnum", description="Register number") int regnum) throws REBException {
        String fmt = String.format("Register %%s: %%0%sx", 2 * this.getRegSizes()[regnum &= 7]);
        return String.format(fmt, regnum, this.readRegister(regnum));
    }

    @Command(name="writeregister", description="Write a register")
    public void writeReg(@Argument(name="regnum", description="Register number") int regnum, @Argument(name="value", description="Value to write") int value) throws REBException {
        this.writeRegister(regnum, value);
    }

    @Command(name="setdelay", description="Set read and write delays")
    public void setDelays(@Argument(name="rdelay", description="Read delay (ms)") int rDelay, @Argument(name="wdelay", description="Write delay (ms)") int wDelay) throws REBException {
        this.setDelay(rDelay, wDelay);
    }

    @Command(name="setdebug", description="Set debug state on or off")
    public void setDebug(@Argument(name="state", description="Debug state") TestReg.OnOff state) throws REBException {
        this.setDebug(state == TestReg.OnOff.ON);
    }

    private int getOption(OptionNames[] optns) {
        int option = 0;
        for (OptionNames optn : optns) {
            option |= optn.getValue();
        }
        return option;
    }

    private static String showStats(String name, int count, double sum, double sumsq) {
        double mean = sum / (double)count;
        double sigsq = sumsq / (double)count - mean * mean;
        double sigma = sigsq <= 0.0 ? 0.0 : Math.sqrt(sigsq);
        return String.format("%s: mean = %.7g, sigma = %.7g", name, mean, sigma);
    }

    private static String onOff(boolean on) {
        return on ? "on" : "off";
    }

    public void reset() throws REBException {
        this.write(0x700002, 0);
    }

    public void setupStandard() throws REBException {
        this.writeRegister(1, 10);
        this.writeRegister(2, 1808);
        this.writeRegister(5, 0);
    }

    public int getStatus() throws REBException {
        return this.readRegister(0);
    }

    public void setChannel(int chan) throws REBException {
        this.updateRegister(2, 15, chan << 0);
    }

    public int getChannel() throws REBException {
        return (this.readRegister(2) & 0xF) >> 0;
    }

    public void setConvMode(int mode) throws REBException {
        this.updateRegister(1, 57344, mode << 13);
    }

    public int getConvMode() throws REBException {
        return (this.readRegister(1) & 0xE000) >> 13;
    }

    public void setClockSource(int source) throws REBException {
        this.updateRegister(1, 192, source << 6);
    }

    public int getClockSource() throws REBException {
        return (this.readRegister(1) & 0xC0) >> 6;
    }

    public void setPowerSwitch(boolean on) throws REBException {
        this.updateRegister(1, 4096, on ? 4096 : 0);
    }

    public boolean isPowerSwitch() throws REBException {
        return (this.readRegister(1) & 0x1000) != 0;
    }

    public void setConvRate(int rate) throws REBException {
        this.updateRegister(1, 15, rate << 0);
    }

    public int getConvRate() throws REBException {
        return (this.readRegister(1) & 0xF) >> 0;
    }

    public void setUnipolar(boolean enable) throws REBException {
        this.updateRegister(2, 4096, enable ? 4096 : 0);
    }

    public boolean isUnipolar() throws REBException {
        return (this.readRegister(2) & 0x1000) != 0;
    }

    public void setBuffered(boolean enable) throws REBException {
        this.updateRegister(2, 16, enable ? 16 : 0);
    }

    public boolean isBuffered() throws REBException {
        return (this.readRegister(2) & 0x10) != 0;
    }

    public void setRefDetect(boolean enable) throws REBException {
        this.updateRegister(2, 32, enable ? 32 : 0);
    }

    public boolean isRefDetect() throws REBException {
        return (this.readRegister(2) & 0x20) != 0;
    }

    public void setRefSelect(int mode) throws REBException {
        this.updateRegister(2, 192, mode << 6);
    }

    public int getRefSelect() throws REBException {
        return (this.readRegister(2) & 0xC0) >> 6;
    }

    public void setGain(int gain) throws REBException {
        this.updateRegister(2, 1792, gain << 8);
    }

    public int getGain() throws REBException {
        return (this.readRegister(2) & 0x700) >> 8;
    }

    public void setDio(int value) throws REBException {
        int mask = ((value & 1) != 0 ? 64 : 0) | ((value & 2) != 0 ? 16 : 0) | ((value & 4) != 0 ? 32 : 0);
        this.updateRegister(5, 112, mask);
    }

    public int getDio() throws REBException {
        int mask = this.readRegister(5) & 0x70;
        return ((mask & 0x40) != 0 ? 1 : 0) | ((mask & 0x10) != 0 ? 2 : 0) | ((mask & 0x20) != 0 ? 4 : 0);
    }

    public void setSourceDirection(int dirn) throws REBException {
        this.updateRegister(5, 12, dirn << 2);
    }

    public int getSourceDirection() throws REBException {
        return (this.readRegister(5) & 0xC) >> 2;
    }

    public void setSourceEnable(int enab) throws REBException {
        this.updateRegister(5, 3, enab << 0);
    }

    public int getSourceEnable() throws REBException {
        return (this.readRegister(5) & 3) >> 0;
    }

    public int readAdc(int chan, int optns) throws REBException {
        this.updateRegister(2, 15, chan << 0);
        if ((optns & 1) != 0) {
            int mode = (optns & 2) != 0 ? 1 : 0;
            this.updateRegister(1, 57344, mode << 13);
        }
        if ((optns & 4) == 0) {
            this.waitReady();
        }
        return this.readRegister(3);
    }

    public double readTemperature(int optns) throws REBException {
        return ((double)this.readAdc(6, optns) / 8388608.0 - 1.0) * 1.17 * 100.0;
    }

    public double readVdd(int optns) throws REBException {
        return ((double)this.readAdc(7, optns) / 8388608.0 - 1.0) * 1.17 * 6.0;
    }

    public int calibrate(int chan, int type) throws REBException {
        this.updateRegister(2, 15, chan << 0);
        this.updateRegister(1, 57344, (type | 4) << 13);
        this.waitReady();
        return this.readRegister((type & 1) == 0 ? 6 : 7);
    }

    public int[] getCalibration(int chan) throws REBException {
        this.updateRegister(2, 15, chan << 0);
        int[] value = new int[]{this.readRegister(6), this.readRegister(7)};
        return value;
    }

    public int readRegister(int regnum) throws REBException {
        int reg = regnum & 7;
        this.write(0x700000, 0x80000 | reg << 16);
        return this.read(0x700001) & (1 << 8 * REG_SIZE[reg]) - 1;
    }

    public void writeRegister(int regnum, int value) throws REBException {
        int reg = regnum & 7;
        int val = REG_SIZE[reg] == 1 ? (value & 0xFF) << 8 : value & 0xFFFF;
        this.write(0x700000, reg << 16 | val);
    }

    public void updateRegister(int regnum, int mask, int value) throws REBException {
        int reg = regnum & 7;
        this.write(0x700000, 0x80000 | reg << 16);
        int val = this.read(0x700001) & ~mask | value & mask;
        val = REG_SIZE[reg] == 1 ? (val & 0xFF) << 8 : val & 0xFFFF;
        this.write(0x700000, reg << 16 | val);
    }

    @Override
    public int read(int addr) throws REBException {
        if (this.debug) {
            System.out.format("%s read  %08x:", System.currentTimeMillis(), addr);
        }
        int value = super.read(addr);
        if (this.debug) {
            System.out.format(" %08x\n", value);
        }
        this.sleep(this.readDelay);
        return value;
    }

    @Override
    public void write(int addr, int value) throws REBException {
        if (this.debug) {
            System.out.format("%s write %08x: %08x\n", System.currentTimeMillis(), addr, value);
        }
        super.write(addr, value);
        this.sleep(this.writeDelay);
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public void setDelay(int rDelay, int wDelay) {
        this.readDelay = rDelay;
        this.writeDelay = wDelay;
    }

    public int[] getRegSizes() {
        return REG_SIZE;
    }

    private void waitReady() throws REBException {
        long start = System.currentTimeMillis();
        boolean ready = false;
        while (!(ready = (this.getStatus() & 0x80) == 0) && System.currentTimeMillis() - start <= 5000L) {
            this.sleep(10);
        }
        if (!ready) {
            throw new REBException("Conversion timed out");
        }
    }

    private void sleep(int msec) throws REBException {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        for (ChanNames chanNames : ChanNames.values()) {
            chanValues.put(chanNames.getValue(), chanNames.name().toLowerCase());
        }
        cnvModeValues = new HashMap<Integer, String>();
        for (Enum enum_ : CnvModeNames.values()) {
            cnvModeValues.put(((CnvModeNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        rateValues = new HashMap<Integer, String>();
        for (Enum enum_ : RateNames.values()) {
            rateValues.put(((RateNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        clockValues = new HashMap<Integer, String>();
        for (Enum enum_ : ClockNames.values()) {
            clockValues.put(((ClockNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        gainValues = new HashMap<Integer, String>();
        for (Enum enum_ : GainNames.values()) {
            gainValues.put(((GainNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        refsValues = new HashMap<Integer, String>();
        for (Enum enum_ : RefsNames.values()) {
            refsValues.put(((RefsNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        calibValues = new HashMap<Integer, String>();
        for (Enum enum_ : CalibNames.values()) {
            calibValues.put(((CalibNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        regName = new String[]{"STAT", "MODE", "CONF", "DATA", " ID ", " IO ", "OFFS", "FSCL"};
        regDesc0 = new String[]{"| ~RDY |  ERR |NOXREF|  --  | 7794 | CHAN2| CHAN1| CHAN0|", "| MOD2 | MOD1 | MOD0 |  PSW |  --  |  --  |AMPCOM|  --  |", "|VBIAS1|VBIAS0|BRNOUT|UNIPOL| BOOST| GAIN2| GAIN1| GAIN0|", "", "", "|  --  |DIOENA|IODAT2|IODAT1|CSDIR1|CSDIR0|CSENA1|CSENA0|", "", ""};
        regDesc1 = new String[]{"", "| CLK1 | CLK0 |  --  |CHPDIS| FRS3 | FRS2 | FRS1 | FRS0 |", "|RFSEL1|RFSEL0|REFDET|BUFFRD| CHAN3| CHAN2| CHAN1| CHAN0|", "", "", "", "", ""};
        REG_SIZE = new int[]{1, 2, 2, 3, 1, 1, 3, 3};
    }

    public static enum OptionNames {
        CONFIG(1),
        SINGLE(2),
        IMMED(4);

        private final int value;

        private OptionNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum CalibNames {
        INTOFF(0),
        INTGAIN(1),
        EXTOFF(2),
        EXTGAIN(3);

        private final int value;

        private CalibNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum RefsNames {
        EXT1(0),
        EXT2(1),
        INTERNAL(2);

        private final int value;

        private RefsNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum GainNames {
        X1(0),
        X2(1),
        X4(2),
        X8(3),
        X16(4),
        X32(5),
        X64(6),
        X128(7);

        private final int value;

        private GainNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum ClockNames {
        INTERNAL(0),
        INTAVAIL(1),
        EXTERNAL(2),
        EXTHALF(3);

        private final int value;

        private ClockNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum RateNames {
        R470(1),
        R242(2),
        R123(3),
        R62(4),
        R50(5),
        R39(6),
        R33(7),
        R19(8),
        R17(9),
        R16(10),
        R12(11),
        R10(12),
        R8(13),
        R6(14),
        R4(15);

        private final int value;

        private RateNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum CnvModeNames {
        CONTINUOUS(0),
        SINGLE(1),
        IDLE(2),
        POWERDOWN(3),
        INTOFFCAL(4),
        INTGAINCAL(5),
        EXTOFFCAL(6),
        EXTGAINCAL(7);

        private final int value;

        private CnvModeNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum ChanNames {
        AIN1(0),
        AIN2(1),
        AIN3(2),
        AIN4(3),
        AIN5(4),
        AIN6(5),
        TEMP(6),
        VDD(7);

        private final int value;

        private ChanNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

