/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Sequencer
extends BaseSet {
    public static final int REG_SEQ_LINES = 0x100000;
    public static final int REG_SEQ_TIMES = 0x200000;
    public static final int REG_SEQ_STACK = 0x300000;
    public static final int REG_SEQ_PROGRAM = 0x300000;
    public static final int REG_SEQ_STEP = 0x310000;
    public static final int REG_SEQ_STOP = 0x320000;
    public static final int REG_SEQ_SCAN_CNTRL = 0x330000;
    public static final int REG_SEQ_SCAN_RESET_2 = 0x340000;
    public static final int REG_SEQ_SCAN_RESET = 0x330001;
    public static final int REG_SEQ_START_ADDR = 0x340000;
    public static final int REG_SEQ_EXEC_REFS = 0x350000;
    public static final int REG_SEQ_EXEC_REPS = 0x360000;
    public static final int REG_SEQ_JUMP_REFS = 0x370000;
    public static final int REG_SEQ_JUMP_REPS = 0x380000;
    public static final int REG_SEQ_ERROR_VALUE = 0x390000;
    public static final int REG_SEQ_ERROR_RESET = 3735553;
    public static final int REG_SEQ_SSIZE = 0x400000;
    public static final int REG_SEQ_NSLICE = 0x400005;
    public static final int REG_SEQ_SOURCE = 0x400006;
    public static final int REG_SEQ_STRIPE = 0x400007;
    public static final int REG_SEQ_BEB = 0x400007;
    public static final int REG_SEQ_STEP_0 = 0x500000;
    public static final int REG_SEQ_STOP_0 = 0x600000;
    public static final int SEQ_MAX_FUNC_0 = 4;
    public static final int SEQ_MAX_FUNC = 16;
    public static final int SEQ_MAX_SLICE = 16;
    public static final int SEQ_MAX_PROGRAM = 1024;
    public static final int SEQ_MAX_STACK = 4096;
    public static final int SEQ_MAX_PARAMETER = 16;
    public static final int SEQ_SRC_FPGA_PTN = 0;
    public static final int SEQ_SRC_BEB_PTN = 7147;
    public static final int SEQ_SRC_BEB_ADC = 3051;
    public static final int SEQ_SRC_ADC = 0;
    public static final int SEQ_SRC_PATTERN = 1;
    public static final int SEQ_OPC_EXECUTE = 1;
    public static final int SEQ_OPC_EXECUTE_FP = 2;
    public static final int SEQ_OPC_EXECUTE_RP = 3;
    public static final int SEQ_OPC_EXECUTE_FRP = 4;
    public static final int SEQ_OPC_JUMP_1 = 2;
    public static final int SEQ_OPC_JUMP = 5;
    public static final int SEQ_OPC_JUMP_AP = 6;
    public static final int SEQ_OPC_JUMP_RP = 7;
    public static final int SEQ_OPC_JUMP_ARP = 8;
    public static final int SEQ_OPC_END_SUBR_1 = 3;
    public static final int SEQ_OPC_END_SUBR = 14;
    public static final int SEQ_OPC_END_PROG_1 = 4;
    public static final int SEQ_OPC_END_PROG = 15;
    public static final int SEQ_ARG_IND_FUNC = 1;
    public static final int SEQ_ARG_IND_JUMP = 1;
    public static final int SEQ_ARG_IND_COUNT = 2;
    public static final int SEQ_ARG_IND_MASK = 3;
    public static final int SEQ_ERR_M_CODE = -268435456;
    public static final int SEQ_ERR_M_ADDR = 0xFFFFFFF;
    public static final int SEQ_PRG_V_OPCODE = 28;
    public static final int SEQ_PRG_V_FUNC = 24;
    public static final int SEQ_PRG_M_FUNC = 15;
    public static final int SEQ_PRG_M_EXCCNT = 0xFFFFFF;
    public static final int SEQ_PRG_M_LOOP = 0x800000;
    public static final int SEQ_PRG_V_SUBADD_1 = 18;
    public static final int SEQ_PRG_V_SUBADD = 16;
    public static final int SEQ_PRG_M_SUBADD = 1023;
    public static final int SEQ_PRG_M_SUBCNT_1 = 131071;
    public static final int SEQ_PRG_M_SUBCNT = 65535;
    public static final int SEQ_PRG_M_PARM = 15;
    public static final int SEQ_STK_V_FUNC = 28;
    public static final int SEQ_STK_M_FUNC = 3;
    public static final int SEQ_STK_V_LOOP = 27;
    public static final int SEQ_STK_M_COUNT = 0x7FFFFFF;
    public static final int MAX_SUBR_LEVEL = 16;
    protected int[][] lines = new int[16][16];
    protected int[][] times = new int[16][16];
    protected int[] prog = new int[1024];
    protected int[] stack = new int[4096];
    protected int[] execRefs = new int[16];
    protected int[] execReps = new int[16];
    protected int[] jumpRefs = new int[16];
    protected int[] jumpReps = new int[16];
    protected int stackSize;
    protected int startAddr;

    public Sequencer(RegClient reg) {
        super(reg);
    }

    public Sequencer() {
    }

    @Override
    public void enable() throws REBException {
        this.enable(2);
    }

    @Override
    public void disable() throws REBException {
        this.disable(2);
    }

    public long getTriggerTime() throws REBException {
        return this.getTriggerTime(2);
    }

    public void writeLines(int func, int slice, int value) throws REBException {
        this.checkFunc(func);
        this.checkSlice(slice);
        this.write(0x100000 | func << 4 | slice, value);
        this.lines[func][slice] = value;
    }

    public void writeLines(int func, int[] values) throws REBException {
        this.writeLines(func, values, 0, values.length);
    }

    public void writeLines(int func, int[] values, int offset, int count) throws REBException {
        this.checkFunc(func);
        this.checkSlice(count - 1);
        this.write(0x100000 | func << 4, values, offset, count);
        System.arraycopy(values, offset, this.lines[func], 0, count);
    }

    public void writeTimes(int func, int slice, int value) throws REBException {
        this.checkFunc(func);
        this.checkSlice(slice);
        this.write(0x200000 | func << 4 | slice, value);
        this.times[func][slice] = value;
    }

    public void writeTimes(int func, int[] values) throws REBException {
        this.writeTimes(func, values, 0, values.length);
    }

    public void writeTimes(int func, int[] values, int offset, int count) throws REBException {
        this.checkFunc(func);
        this.checkSlice(count - 1);
        this.write(0x200000 | func << 4, values, offset, count);
        System.arraycopy(values, offset, this.times[func], 0, count);
    }

    public void writeStack(int addr, int value) throws REBException {
        this.checkVersion(0, 0);
        this.checkStackAddr(addr);
        this.write(0x300000 + addr, value);
        this.stack[addr] = value;
    }

    public void writeStack(int addr, int[] values) throws REBException {
        this.writeStack(addr, values, 0, values.length);
    }

    public void writeStack(int addr, int[] values, int offset, int count) throws REBException {
        this.checkVersion(0, 0);
        this.checkStackAddr(addr, count);
        this.write(0x300000 + addr, values, offset, count);
        System.arraycopy(values, offset, this.stack, addr, count);
    }

    public void writeStack(int[] values) throws REBException {
        this.writeStack(values, 0, values.length);
    }

    public void writeStack(int[] values, int offset, int count) throws REBException {
        this.checkVersion(0, 0);
        this.checkStackAddr(0, count);
        this.write(0x300000, values, offset, count);
        this.write(0x400000, count);
        System.arraycopy(values, offset, this.stack, 0, count);
        this.stackSize = count;
    }

    public void writeStackSize(int value) throws REBException {
        this.checkVersion(0, 0);
        this.write(0x400000, value);
        this.stackSize = value;
    }

    public void writeProgram(int addr, int value) throws REBException {
        this.checkNotVersion(0, 0);
        this.checkProgAddr(addr);
        this.write(0x300000 + addr, value);
        this.prog[addr] = value;
    }

    public void writeProgram(int addr, int[] values) throws REBException {
        this.writeProgram(addr, values, 0, values.length);
    }

    public void writeProgram(int addr, int[] values, int offset, int count) throws REBException {
        this.checkNotVersion(0, 0);
        this.checkProgAddr(addr, count);
        this.write(0x300000 + addr, values, offset, count);
        System.arraycopy(values, offset, this.prog, addr, count);
    }

    public void writeProgExec(int addr, int func, int count) throws REBException {
        if (this.isVersion(0, 3)) {
            this.writeProgExec(addr, 0, func, count);
        } else {
            this.checkFunc(func);
            this.writeProgram(addr, count | func << 24 | 0x10000000);
        }
    }

    public void writeProgExec(int addr, int argType, int func, int count) throws REBException {
        this.checkVersion(0, 3);
        if (((argType &= 3) & 1) == 0) {
            this.checkFunc(func);
        } else {
            this.checkParamAddr(func);
        }
        if ((argType & 2) == 0) {
            this.checkExecCount(count);
        } else {
            this.checkParamAddr(count);
        }
        this.writeProgram(addr, 1 + argType << 28 | func << 24 | count);
    }

    public void writeProgJump(int addr, int subaddr, int count) throws REBException {
        if (this.isVersion(0, 3)) {
            this.writeProgJump(addr, 0, subaddr, count);
        } else {
            this.checkProgAddr(subaddr);
            this.checkJumpCount(count);
            this.writeProgram(addr, 0x20000000 | subaddr << 18 | count);
        }
    }

    public void writeProgJump(int addr, int argType, int subaddr, int count) throws REBException {
        this.checkVersion(0, 3);
        if (((argType &= 3) & 1) == 0) {
            this.checkProgAddr(subaddr);
        } else {
            this.checkParamAddr(subaddr);
        }
        if ((argType & 2) == 0) {
            this.checkJumpCount(count);
        } else {
            this.checkParamAddr(count);
        }
        this.writeProgram(addr, 5 + argType << 28 | subaddr << 16 | count);
    }

    public void writeProgEndSubr(int addr) throws REBException {
        int opcode = this.isVersion(0, 3) ? 14 : 3;
        this.writeProgram(addr, opcode << 28);
    }

    public void writeProgEnd(int addr) throws REBException {
        int opcode = this.isVersion(0, 3) ? 15 : 4;
        this.writeProgram(addr, opcode << 28);
    }

    public void writeExecFunc(int addr, int func) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        this.checkFunc(func);
        this.write(0x350000 + addr, func);
        this.execRefs[addr] = func;
    }

    public int readExecFunc(int addr) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        return this.read(0x350000 + addr);
    }

    public void writeExecCount(int addr, int count) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        this.checkExecCount(count);
        this.write(0x360000 + addr, count);
        this.execReps[addr] = count;
    }

    public int readExecCount(int addr) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        return this.read(0x360000 + addr);
    }

    public void writeJumpSubr(int addr, int subr) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        this.checkProgAddr(subr);
        this.write(0x370000 + addr, subr);
        this.jumpRefs[addr] = subr;
    }

    public int readJumpSubr(int addr) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        return this.read(0x370000 + addr);
    }

    public void writeJumpCount(int addr, int count) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        this.checkJumpCount(count);
        this.write(0x380000 + addr, count);
        this.jumpReps[addr] = count;
    }

    public int readJumpCount(int addr) throws REBException {
        this.checkVersion(0, 3);
        this.checkParamAddr(addr);
        return this.read(0x380000 + addr);
    }

    public void writeStartAddr(int value) throws REBException {
        this.checkVersion(0, 3);
        this.checkProgAddr(value);
        this.write(0x340000, value);
        this.startAddr = 0;
    }

    public int readStartAddr() throws REBException {
        this.checkVersion(0, 3);
        return this.read(0x340000);
    }

    public void writeSliceCount(int value) throws REBException {
        this.write(0x400005, value);
    }

    public int readSliceCount() throws REBException {
        return this.read(0x400005);
    }

    public void writeDataSource(int value) throws REBException {
        this.write(0x400006, value);
    }

    public int readDataSource() throws REBException {
        return this.read(0x400006);
    }

    public void writeStripeSelect(int value) throws REBException {
        this.checkNotVersion(0, 0);
        this.write(0x400007, value);
    }

    public int readStripeSelect() throws REBException {
        this.checkNotVersion(0, 0);
        return this.read(0x400007);
    }

    public void writeBebSelect(int value) throws REBException {
        this.checkVersion(0, 0);
        this.write(0x400007, value);
    }

    public void sendStep() throws REBException {
        int stepAddr = this.isVersion(0, 0) ? 0x500000 : 0x310000;
        this.write(stepAddr, 0);
    }

    public void sendStop() throws REBException {
        int stopAddr = this.isVersion(0, 0) ? 0x600000 : 0x320000;
        this.write(stopAddr, 0);
    }

    public void enableScan(boolean enable) throws REBException {
        this.checkVersion(0, 2, 3);
        this.write(0x330000, enable ? 1 : 0);
    }

    public boolean isScanEnabled() throws REBException {
        this.checkVersion(0, 2, 3);
        return (this.read(0x330000) & 1) != 0;
    }

    public void resetScan() throws REBException {
        this.checkVersion(0, 2, 3);
        int addr = this.isVersion(0, 2) ? 0x340000 : 0x330001;
        this.write(addr, 0);
    }

    public int getErrorAddr() throws REBException {
        if (this.getVersion(0, true) < 3) {
            return -1;
        }
        int value = this.read(0x390000);
        return (value & 0xF0000000) != 0 ? value & 0xFFFFFFF : -1;
    }

    public void resetError() throws REBException {
        if (this.getVersion(0, true) < 3) {
            return;
        }
        this.write(3735553, 0);
    }

    public void clearCache() throws REBException {
        int j;
        for (j = 0; j < this.lines.length; ++j) {
            for (int k = 0; k < this.lines[j].length; ++k) {
                this.lines[j][k] = 0;
                this.times[j][k] = 0;
            }
        }
        if (this.isVersion(0, 0)) {
            for (j = 0; j < this.stack.length; ++j) {
                this.stack[j] = 0;
            }
            this.stackSize = 0;
        } else {
            for (j = 0; j < this.prog.length; ++j) {
                this.prog[j] = 0;
            }
        }
        if (this.isVersion(0, 3)) {
            for (j = 0; j < this.execRefs.length; ++j) {
                this.execRefs[j] = 0;
                this.execReps[j] = 0;
                this.jumpRefs[j] = 0;
                this.jumpReps[j] = 0;
            }
            this.startAddr = 0;
        }
    }

    public int getCacheSliceCount() throws REBException {
        int maxFunc = this.isVersion(0, 0) ? 4 : 16;
        int[] funcSlice = new int[maxFunc];
        int[] funcSend = new int[maxFunc];
        for (int j = 1; j < maxFunc; ++j) {
            int nSlice = 0;
            int send = 0;
            boolean prevAdc = false;
            boolean prevSoi = false;
            boolean prevEoi = false;
            for (int k = 0; k < 16 && this.times[j][k] != 0; ++k) {
                boolean adc;
                int line = this.lines[j][k];
                if ((line & 0x2000) != 0) {
                    send = 1;
                }
                if ((line & 0x4000) != 0) {
                    send = -1;
                }
                if ((adc = (line & 0x1000) != 0) & !prevAdc) {
                    ++nSlice;
                }
                prevAdc = adc;
            }
            funcSend[j] = send;
            funcSlice[j] = nSlice;
        }
        if (this.isVersion(0, 0)) {
            int nSlice = 0;
            for (int j = 0; j < this.stackSize; ++j) {
                int func = this.stack[j] >> 28 & 3;
                int count = this.stack[j] & 0x7FFFFFF;
                if (funcSlice[func] != 0 && (this.stack[j] & 0x8000000) != 0) {
                    throw new REBException("Data-producing infinite loop");
                }
                nSlice += count * funcSlice[func];
            }
            return nSlice;
        }
        return this.getProgSlices(this.startAddr, 0, funcSlice, funcSend);
    }

    private int getProgSlices(int addr, int level, int[] funcSlice, int[] funcSend) throws REBException {
        int subaddV;
        int nSlice = 0;
        int version = this.getVersion(0);
        int opcExecFP = version == 3 ? 2 : -1;
        int opcExecRP = version == 3 ? 3 : -1;
        int opcExecFRP = version == 3 ? 4 : -1;
        int opcJump = version == 3 ? 5 : 2;
        int opcJumpAP = version == 3 ? 6 : -1;
        int opcJumpRP = version == 3 ? 7 : -1;
        int opcJumpARP = version == 3 ? 8 : -1;
        int opcEndS = version == 3 ? 14 : 3;
        int opcEndP = version == 3 ? 15 : 4;
        int n = subaddV = version == 3 ? 16 : 18;
        while (addr < 1024) {
            int count;
            int cmnd = this.prog[addr];
            int opcode = cmnd >>> 28;
            if (opcode == 1 || opcode == opcExecFP || opcode == opcExecRP || opcode == opcExecFRP) {
                int fSlice;
                int func = opcode == 1 || opcode == opcExecRP ? cmnd >> 24 & 0xF : this.execRefs[cmnd >> 24 & 0xF];
                count = opcode == 1 || opcode == opcExecFP ? cmnd & 0xFFFFFF : this.execReps[cmnd & 0xF];
                funcSend[0] = funcSend[func] == 0 ? funcSend[0] : funcSend[func];
                int n2 = fSlice = funcSend[0] > 0 ? funcSlice[func] : 0;
                if (fSlice != 0 && (count & 0x800000) != 0) {
                    throw new REBException("Data-producing infinite loop");
                }
                nSlice += count * fSlice;
            } else if (opcode == opcJump || opcode == opcJumpAP || opcode == opcJumpRP || opcode == opcJumpARP) {
                if (level >= 16) {
                    throw new REBException("Maximum subroutine level exceeded");
                }
                int sAddr = opcode == opcJump || opcode == opcJumpRP ? cmnd >> subaddV & 0x3FF : this.jumpRefs[cmnd >> subaddV & 0xF];
                count = opcode == opcJump || opcode == opcJumpAP ? cmnd & 0xFFFF : this.jumpReps[cmnd & 0xF];
                int slice = this.getProgSlices(sAddr, level + 1, funcSlice, funcSend);
                nSlice += slice >= 0 ? count * slice : 0xFFFFFFFF ^ slice;
                if (slice < 0) {
                    return nSlice ^ (level == 0 ? 0 : -1);
                }
            } else {
                if (opcode == opcEndS) {
                    if (level == 0) {
                        throw new REBException("Subroutine trailer at top level");
                    }
                    return nSlice;
                }
                if (opcode == opcEndP) {
                    return nSlice ^ (level == 0 ? 0 : -1);
                }
                throw new REBException("Invalid sequencer opcode (" + (cmnd >>> 28) + ")");
            }
            ++addr;
        }
        if (level == 0) {
            throw new REBException("Missing end of program");
        }
        throw new REBException("Missing subroutine trailer");
    }

    public int getVersion() throws REBException {
        return this.getVersion(0, true);
    }

    private void checkFunc(int func) throws REBException {
        int maxFunc;
        int n = maxFunc = this.isVersion(0, 0) ? 4 : 16;
        if (func < 0 || func >= maxFunc) {
            throw new REBException("Invalid function number");
        }
    }

    private void checkSlice(int slice) throws REBException {
        if (slice < 0 || slice >= 16) {
            throw new REBException("Invalid time slice number");
        }
    }

    private void checkStackAddr(int addr) throws REBException {
        if (addr < 0 || addr >= 4096) {
            throw new REBException("Invalid stack address");
        }
    }

    private void checkStackAddr(int addr, int count) throws REBException {
        if (addr < 0 || count <= 0 || addr + count > 4096) {
            throw new REBException("Invalid stack address");
        }
    }

    private void checkProgAddr(int addr) throws REBException {
        if (addr < 0 || addr >= 1024) {
            throw new REBException("Invalid program address");
        }
    }

    private void checkProgAddr(int addr, int count) throws REBException {
        if (addr < 0 || count <= 0 || addr + count > 1024) {
            throw new REBException("Invalid program address");
        }
    }

    private void checkParamAddr(int addr) throws REBException {
        if (addr < 0 || addr >= 16) {
            throw new REBException("Invalid parameter address");
        }
    }

    private void checkExecCount(int count) throws REBException {
        if ((count & 0xFF000000) != 0) {
            throw new REBException("Invalid repetition count");
        }
    }

    private void checkJumpCount(int count) throws REBException {
        int mask;
        int n = mask = this.isVersion(0, 3) ? 65535 : 131071;
        if ((count & ~mask) != 0) {
            throw new REBException("Invalid repetition count");
        }
    }
}

