/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Daq1Client {
    static boolean first = true;

    static void loadLibrary() {
        if (first) {
            System.loadLibrary("RebDaq1");
            first = false;
        }
    }

    public static class Global
    implements GlobalClient.Impl {
        long system;

        Global() {
            Daq1Client.loadLibrary();
            Global.initSys();
        }

        private static native void initSys();

        @Override
        public native void newGlobalClient(int[] var1, String var2);

        @Override
        public native void deleteGlobalClient();

        @Override
        public native void triggerImage(String var1);
    }

    public static class Images
    implements ImageClient.Impl {
        long handle;

        Images() {
            Daq1Client.loadLibrary();
            Images.initSys();
        }

        private static native void initSys();

        @Override
        public void newImageClient(int id, String ifc) {
            this.handle = this.newImageClient1(id);
        }

        private native long newImageClient1(int var1);

        @Override
        public void deleteImageClient() {
            this.deleteImageClient1(this.handle);
        }

        private native void deleteImageClient1(long var1);

        @Override
        public Image waitForImage(Image image) {
            return this.waitForImage1(this.handle, image);
        }

        private native Image waitForImage1(long var1, Image var3);

        @Override
        public native boolean getImage(Image var1);

        @Override
        public void reset() {
            this.reset1(this.handle);
        }

        private native void reset1(long var1);

        @Override
        public native void deleteImageMetadataRef(Image var1);
    }

    public static class Registers
    implements RegClient.Impl {
        int id;

        Registers() {
            Daq1Client.loadLibrary();
        }

        @Override
        public long newRegClient(int id, String ifc) {
            this.id = id;
            return this.newRegClient1(id);
        }

        private native long newRegClient1(int var1);

        @Override
        public native void deleteRegClient(long var1);

        @Override
        public synchronized int readReg(long handle, int address) throws REBException {
            int[] values = new int[1];
            this.readRegs1(handle, this.id, address, values, 0, 1);
            return values[0];
        }

        @Override
        public synchronized void readRegs(long handle, int address, int[] values, int offset, int count) throws REBException {
            this.readRegs1(handle, this.id, address, values, offset, count);
        }

        private native void readRegs1(long var1, int var3, int var4, int[] var5, int var6, int var7) throws REBException;

        @Override
        public synchronized void writeReg(long handle, int address, int value) throws REBException {
            int[] values = new int[]{value};
            this.writeRegs1(handle, this.id, address, values, 0, 1);
        }

        @Override
        public synchronized void writeRegs(long handle, int address, int[] values, int offset, int count) throws REBException {
            this.writeRegs1(handle, this.id, address, values, offset, count);
        }

        private native void writeRegs1(long var1, int var3, int var4, int[] var5, int var6, int var7) throws REBException;

        @Override
        public synchronized int updateReg(long handle, int address, int mask, int value) throws REBException {
            int[] values = new int[]{0};
            this.readRegs1(handle, this.id, address, values, 0, 1);
            int oldVal = values[0];
            values[0] = values[0] & ~mask | value & mask;
            this.writeRegs1(handle, this.id, address, values, 0, 1);
            return oldVal;
        }

        private native void updateReg1(long var1, int var3, int var4, int var5, int var6) throws REBException;
    }
}

