package org.lsst.ccs.drivers.reb.sim;

import java.math.BigDecimal;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation.WaveformListener;

/**
 * A waveform listener which can be attached to a sequencer to count the number of 
 * pixels (ADC samples) generated,
 * @author tonyj
 */
public class PixelCounter implements WaveformListener {

    private final static int TRG = 12;  // ADC sampling trigger
    private final static int SOI = 13;  // Start of image
    private final static int EOI = 14;  // End of image
    
    private final int TRG_MASK = 1<<TRG;
    private final int SOI_MASK = 1<<SOI;
    private final int EOI_MASK = 1<<EOI;
    
    private int pixels = 0;
    private boolean imageActive;
    

    @Override
    public void transition(int oldState, int newState, int timeSlice, BigDecimal clockPeriod) {
        if ((oldState & SOI_MASK) == 0 && (newState &  SOI_MASK) != 0) {
            imageActive = true;
        }
        if ((oldState & EOI_MASK) == 0 && (newState &  EOI_MASK) != 0) {
            imageActive = false;
        }
        if (imageActive && (oldState & TRG_MASK) == 0 && (newState &  TRG_MASK) != 0) {
            pixels++;
        }
    }

    public int getPixels() {
        return pixels;
    }

    void reset() {
        pixels = 0;
        imageActive = false;
    }
}
