package org.lsst.ccs.drivers.reb.sim;

/**
 * This does not really simulate the DAQ, but provides a communication path for
 * information which in real-life travels through the DAQ.
 *
 * @author tonyj
 */
public class DAQSimulation {

    private int rebType;
    private int[] registers;
    private String imageName;
    private DataProvider dataProvider = new TrivialDataProvider();

    public void setRegisterList(int rebType, int[] registers) {
        //TODO: rebType indicates if this is a science, guider or wavefront sensor
        // We are not really handling this properly right now.
        this.rebType = rebType;
        this.registers = registers;
    }

    public int getRebType() {
        return rebType;
    }

    public int[] getRegisters() {
        return registers;
    }

    void setImageName(String name) {
        this.imageName = name;
    }

    public String getImageName() {
        return imageName;
    }

    DataProvider getDataProvider() {
        return dataProvider;
    }

    void setDataProvider(DataProvider dp) {
        this.dataProvider = dp;
    }
}
