package org.lsst.ccs.drivers.rcm;

import java.io.PrintStream;

/**
 ***************************************************************************
 **
 **  Program to test the speed of Java RCM register access routines
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class TestSpeed {

    private final static PrintStream out = System.out;


   /**
    ***************************************************************************
    **
    **  Main program
    **
    ***************************************************************************
    */
    public static void main(String[] args) throws RcmException
    {
        if (args.length < 3) {
            out.println("Parameters are: rcmid regnum nreg count");
            System.exit(0);
        }
        int[] iArgs = new int[4];
        for (int j = 0; j < iArgs.length; j++) {
            try {
                iArgs[j] = Integer.decode(args[j]);
            }
            catch (NumberFormatException e) {
                out.println("Invalid integer for parameter " + j);
                System.exit(0);
            }
        }
        (new TestSpeed()).run(iArgs[0], iArgs[1], iArgs[2], iArgs[3]);
        System.exit(0);
    }


   /**
    ***************************************************************************
    **
    **  Runs the test
    **
    ***************************************************************************
    */
    public void run(int rcmid, int regnum, int nreg, int count)
        throws RcmException
    {
        RegClient reg = new RegClient();
        reg.open(rcmid);
        long start = System.currentTimeMillis();
        int nread = 0;
        int[] data = new int[nreg];
        for (int j = 0; j < count; j++) {
            reg.read(regnum, data);
            nread += nreg;
        }
        long time = System.currentTimeMillis() - start;
        int rate = (time == 0) ? 0 : (int)((1000 * nread) / time);
        out.format("Performed %s reads in %s msecs, rate = %s reads/sec\n",
                   nread, time, rate);
    }

}