package org.lsst.ccs.drivers.rcm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * RCM vocabulary. Parsed from HDL file.
 * 
 * @author aubourg
 * 
 */
public class RCMCommands {

	int version; // the version of this vocabulary. To be implemented and
					// compared with REB register #1

	public RCMCommands(String file) {
		try {
			parseHDL(new File(file));
		} catch (IOException e) {
			throw new RuntimeException("error reading HDL file " + file, e);
		}
	}

	protected void parseHDL(File f) throws IOException {
		BufferedReader r = new BufferedReader(new FileReader(f));
		parseHDL(r);
	}

	protected void parseHDL(BufferedReader r) throws IOException {
		// constant func_time_set_base :std_logic_vector(23 downto 0) :=
		// x"200000";

		
		Pattern p = Pattern.compile("\\s*constant\\s+([a-zA-Z0-9_]+)\\s+:std_logic_vector\\([0-9a-z ]+\\)\\s*:=\\s*x\"([0-9a-f]+)\".*");

		while (true) {
			String line = r.readLine();
			if (line == null)
				break;
			Matcher m = p.matcher(line);
			if (!m.matches()) continue;
			String key = m.group(1);
			String hex = m.group(2);
			Integer value = Integer.valueOf(hex, 16);
			System.out.println(line);
			//System.out.println(key+" "+value);
			addresses.put(key, value);
		}

		r.close();
	}

	Map<String, Integer> addresses = new HashMap<String, Integer>();

	public static void main(String[] args) {
		new RCMCommands(args[0]);
	}

	int getAddress(String key) {
		return addresses.get(key);
	}
	
}
