/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.shell.CLIException;
import org.lsst.ccs.shell.Command;
import org.lsst.ccs.shell.CommandNamer;
import org.lsst.ccs.shell.LocalShellCommand;
import org.lsst.ccs.shell.ShellCommand;
import org.lsst.ccs.shell.Token;

public class CommandTable {
    private List<ShellCommand> commandTable = new ArrayList<ShellCommand>();
    private CommandNamer namer;

    public CommandNamer getNamer() {
        return this.namer;
    }

    public CommandTable(CommandNamer namer) {
        this.namer = namer;
    }

    public List<ShellCommand> getCommandTable() {
        return Collections.unmodifiableList(this.commandTable);
    }

    public void addShellCommand(ShellCommand command) {
        this.commandTable.add(command);
    }

    public void addMethod(Method method, Object handler, String prefix) {
        String name;
        Command annotation = method.getAnnotation(Command.class);
        assert (method != null);
        String autoAbbrev = null;
        if (annotation != null && annotation.name() != null && !annotation.name().equals("")) {
            name = annotation.name();
        } else {
            CommandNamer.NamingInfo autoNames = this.namer.nameCommand(method);
            name = autoNames.commandName;
            String[] stringArray = autoNames.possibleAbbreviations;
            int n = autoNames.possibleAbbreviations.length;
            int n2 = 0;
            while (n2 < n) {
                String abbr = stringArray[n2];
                if (!this.doesCommandExist(String.valueOf(prefix) + abbr, method.getParameterTypes().length)) {
                    autoAbbrev = abbr;
                    break;
                }
                ++n2;
            }
        }
        LocalShellCommand command = new LocalShellCommand(handler, method, prefix, name);
        if (annotation != null && annotation.abbrev() != null && !annotation.abbrev().equals("")) {
            command.setAbbreviation(annotation.abbrev());
        } else {
            command.setAbbreviation(autoAbbrev);
        }
        if (annotation != null && annotation.description() != null && !annotation.description().equals("")) {
            command.setDescription(annotation.description());
        }
        if (annotation != null && annotation.header() != null && !annotation.header().equals("")) {
            command.setHeader(annotation.header());
        }
        this.addShellCommand(command);
    }

    private boolean doesCommandExist(String commandName, int arity) {
        for (ShellCommand cmd : this.commandTable) {
            if (!cmd.canBeDenotedBy(commandName) || cmd.getArity() != arity) continue;
            return true;
        }
        return false;
    }

    public List<ShellCommand> commandsByName(String discriminator) {
        ArrayList<ShellCommand> collectedTable = new ArrayList<ShellCommand>();
        for (ShellCommand cs : this.commandTable) {
            if (!cs.canBeDenotedBy(discriminator)) continue;
            collectedTable.add(cs);
        }
        return collectedTable;
    }

    public ShellCommand lookupCommand(String discriminator, List<Token> tokens) throws CLIException {
        List<ShellCommand> collectedTable = this.commandsByName(discriminator);
        ArrayList<ShellCommand> reducedTable = new ArrayList<ShellCommand>();
        for (ShellCommand cs : collectedTable) {
            if (cs.getParamSpecs().length != tokens.size() - 1 && (!cs.isVarArgs() || cs.getParamSpecs().length > tokens.size() - 1)) continue;
            reducedTable.add(cs);
        }
        if (collectedTable.size() == 0) {
            throw CLIException.createCommandNotFound(discriminator);
        }
        if (reducedTable.size() == 0) {
            throw CLIException.createCommandNotFoundForArgNum(discriminator, tokens.size() - 1);
        }
        if (reducedTable.size() > 1) {
            throw CLIException.createAmbiguousCommandExc(discriminator, tokens.size() - 1);
        }
        return (ShellCommand)reducedTable.get(0);
    }
}

