/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;
import org.lsst.ccs.drivers.rcm.Status;

public class StatusSet
extends BaseSet {
    public static final int REG_STATUS = 0x800000;
    public static final int OFF_STAT_VERSION = 0;
    public static final int OFF_STAT_LINKSTAT = 1;
    public static final int OFF_STAT_CERR_CNT = 2;
    public static final int OFF_STAT_LDWN_CNT = 3;
    public static final int OFF_STAT_LERR_CNT = 4;
    public static final int OFF_STAT_BUFFSTAT = 5;
    public static final int OFF_STAT_RX_CNTS = 6;
    public static final int OFF_STAT_TX_CNTS = 10;
    public static final int NUM_STAT_REG = 14;
    private int baseAddr;

    public StatusSet() {
    }

    public StatusSet(RegClient reg) {
        super(reg);
    }

    @Override
    public void enable() throws RcmException {
        this.enable(0);
    }

    @Override
    public void disable() throws RcmException {
        this.disable(0);
    }

    public long getTriggerTime() throws RcmException {
        return this.getTriggerTime(0);
    }

    public Status readStatus() throws RcmException {
        Status status = new Status();
        int[] regs = new int[14];
        this.read(0x800000, regs);
        status.version = regs[0];
        status.linkStat = regs[1];
        status.cerrCount = regs[2];
        status.ldwnCount = regs[3];
        status.lerrCount = regs[4];
        status.buffStat = regs[5];
        int j = 0;
        while (j < status.rxCount.length) {
            status.rxCount[j] = regs[6 + j];
            ++j;
        }
        j = 0;
        while (j < status.txCount.length) {
            status.txCount[j] = regs[10 + j];
            ++j;
        }
        return status;
    }
}

