/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;
import org.lsst.ccs.drivers.rcm.Sequencer;

public class SequencerUtils
extends Sequencer {
    private static final int SEQTYPE_REGISTER = 0;
    private static final int SEQTYPE_OUTPUT = 1;
    private static final int SEQTYPE_TIMES = 2;
    private static final int SEQTYPE_PROGRAM = 3;
    private static final int SEQTYPE_PROGEXEC = 4;
    private static final int SEQTYPE_PROGJUMP = 5;
    private static final int SEQTYPE_PROGSUBE = 6;
    private static final int SEQTYPE_PROGEND = 7;
    private static final int SEQTYPE_SLICE = 8;
    private static final int SEQTYPE_SOURCE = 9;
    private static final int SEQTYPE_STACK = 10;
    private static final int SEQTYPE_BEB = 11;
    private static final int MAX_SUBR_LEVEL = 16;
    private static final HashMap<String, Integer> seqTypes = new HashMap();
    private static final HashMap<Integer, Integer> seqMinArgs;
    private int stkSize;

    static {
        seqTypes.put("register", 0);
        seqTypes.put("output", 1);
        seqTypes.put("times", 2);
        seqTypes.put("program", 3);
        seqTypes.put("progexec", 4);
        seqTypes.put("progjump", 5);
        seqTypes.put("progsube", 6);
        seqTypes.put("progend", 7);
        seqTypes.put("slice", 8);
        seqTypes.put("source", 9);
        seqTypes.put("stack", 10);
        seqTypes.put("beb", 11);
        seqMinArgs = new HashMap();
        seqMinArgs.put(0, 3);
        seqMinArgs.put(1, 3);
        seqMinArgs.put(2, 3);
        seqMinArgs.put(3, 3);
        seqMinArgs.put(4, 4);
        seqMinArgs.put(5, 4);
        seqMinArgs.put(6, 2);
        seqMinArgs.put(7, 2);
        seqMinArgs.put(8, 2);
        seqMinArgs.put(9, 2);
        seqMinArgs.put(10, 3);
        seqMinArgs.put(11, 2);
    }

    public SequencerUtils() {
    }

    public SequencerUtils(RegClient reg) {
        super(reg);
    }

    public void loadCommand(String cmnd) throws RcmException {
        this.loadCommand(cmnd, 0);
    }

    public void loadCommand(String cmnd, int lineNum) throws RcmException {
        boolean thrown = false;
        ArrayList<Integer> args = new ArrayList<Integer>();
        String word = "";
        try {
            Scanner scan = new Scanner(cmnd);
            int type = -1;
            int count = 0;
            args.clear();
            while (scan.hasNext()) {
                word = scan.next();
                if (count == 0) {
                    if (word.startsWith("#")) break;
                    Integer iType = seqTypes.get(word);
                    if (iType == null) {
                        thrown = true;
                        this.throwException("Invalid operation (" + word + ")", lineNum);
                    }
                    type = iType;
                } else {
                    args.add((int)Long.decode(word).longValue());
                }
                ++count;
            }
            if (count == 0) {
                return;
            }
            int minArgs = seqMinArgs.get(type);
            if (count < minArgs) {
                thrown = true;
                this.throwException("Too few arguments (" + (count - 1) + ")", lineNum);
            }
            if (minArgs != 3 && count > minArgs) {
                thrown = true;
                this.throwException("Too many arguments (" + (count - 1) + ")", lineNum);
            }
            int arg0 = (Integer)args.get(0);
            if (minArgs == 2) {
                if (type == 6) {
                    this.writeProgEndSubr(arg0);
                } else if (type == 7) {
                    this.writeProgEnd(arg0);
                } else if (type == 8) {
                    this.writeSliceCount(arg0);
                } else if (type == 9) {
                    this.writeDataSource(arg0);
                } else if (type == 11) {
                    this.writeBebSelect(arg0);
                }
            } else {
                int[] values = new int[count - 2];
                int j = 0;
                while (j < values.length) {
                    values[j] = (Integer)args.get(j + 1);
                    ++j;
                }
                if (type == 0) {
                    this.write(arg0, values);
                } else if (type == 1) {
                    this.writeLines(arg0, values);
                } else if (type == 2) {
                    this.writeTimes(arg0, values);
                } else if (type == 3) {
                    this.writeProgram(arg0, values);
                } else if (type == 4) {
                    this.writeProgExec(arg0, values[0], values[1]);
                } else if (type == 5) {
                    this.writeProgJump(arg0, values[0], values[1]);
                } else if (type == 10) {
                    this.writeStack(arg0, values);
                    if (arg0 + values.length > this.stkSize) {
                        this.stkSize = arg0 + values.length;
                        this.writeStackSize(this.stkSize);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Invalid integer (" + word + ")", lineNum);
        }
        catch (RcmException e) {
            if (thrown) {
                throw e;
            }
            this.throwException(e.getMessage(), lineNum);
        }
    }

    public int loadFile(String fileName) throws RcmException, IOException {
        BufferedReader rdr = null;
        int lineNum = 0;
        this.stkSize = 0;
        this.clearCache();
        try {
            String line;
            rdr = new BufferedReader(new FileReader(fileName));
            while ((line = rdr.readLine()) != null) {
                this.loadCommand(line, ++lineNum);
            }
        }
        catch (Throwable throwable) {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (rdr != null) {
            try {
                rdr.close();
            }
            catch (IOException iOException) {}
        }
        return this.getCacheSliceCount();
    }

    public void clearCache() throws RcmException {
        int j = 0;
        while (j < this.lines.length) {
            int k = 0;
            while (k < this.lines[j].length) {
                this.lines[j][k] = 0;
                this.times[j][k] = 0;
                ++k;
            }
            ++j;
        }
        if (this.getVersion() == 0) {
            j = 0;
            while (j < this.stack.length) {
                this.stack[j] = 0;
                ++j;
            }
            this.stackSize = 0;
        } else {
            j = 0;
            while (j < this.prog.length) {
                this.prog[j] = 0;
                ++j;
            }
        }
    }

    public int getCacheSliceCount() throws RcmException {
        int maxFunc = this.getVersion() == 0 ? 4 : 16;
        int[] funcSlice = new int[maxFunc];
        funcSlice[0] = 0;
        int j = 1;
        while (j < maxFunc) {
            int nSlice = 0;
            boolean prevAdc = false;
            int k = 0;
            while (k < 16 && this.times[j][k] != 0) {
                boolean adc = (this.lines[j][k] & 0x1000) != 0;
                if (adc & !prevAdc) {
                    ++nSlice;
                }
                prevAdc = adc;
                ++k;
            }
            funcSlice[j] = nSlice;
            ++j;
        }
        if (this.getVersion() == 0) {
            int nSlice = 0;
            int j2 = 0;
            while (j2 < this.stackSize) {
                int func = this.stack[j2] >> 28 & 3;
                int count = this.stack[j2] & 0x7FFFFFF;
                if (funcSlice[func] != 0 && (this.stack[j2] & 0x1B) != 0) {
                    throw new RcmException("Data-producing infinite loop");
                }
                nSlice += count * funcSlice[func];
                ++j2;
            }
            return nSlice;
        }
        return this.getProgSlices(0, 0, funcSlice);
    }

    private int getProgSlices(int addr, int level, int[] funcSlice) throws RcmException {
        int nSlice = 0;
        while (addr < 1024) {
            int cmnd = this.prog[addr];
            switch (cmnd >>> 28) {
                case 1: {
                    int func = cmnd >> 24 & 0xF;
                    if (funcSlice[func] != 0 && (cmnd & 0x17) != 0) {
                        throw new RcmException("Data-producing infinite loop");
                    }
                    nSlice += (cmnd & 0x7FFFFF) * funcSlice[func];
                    break;
                }
                case 2: {
                    if (level >= 16) {
                        throw new RcmException("Maximum subroutine level exceeded");
                    }
                    int sAddr = cmnd >> 18 & 0x3FF;
                    int count = cmnd & 0x1FFFF;
                    int slice = this.getProgSlices(sAddr, level + 1, funcSlice);
                    nSlice += slice >= 0 ? count * slice : 0xFFFFFFFF ^ slice;
                    if (slice >= 0) break;
                    return nSlice ^ (level == 0 ? 0 : -1);
                }
                case 3: {
                    if (level == 0) {
                        throw new RcmException("Subroutine trailer at top level");
                    }
                    return nSlice;
                }
                case 4: {
                    return nSlice ^ (level == 0 ? 0 : -1);
                }
                default: {
                    throw new RcmException("Invalid sequencer opcode (" + (cmnd >>> 28) + ")");
                }
            }
            ++addr;
        }
        if (level == 0) {
            throw new RcmException("Missing end of program");
        }
        throw new RcmException("Missing subroutine trailer");
    }

    private void throwException(String text, int lineNum) throws RcmException {
        if (lineNum > 0) {
            throw new RcmException(String.valueOf(text) + " at line " + lineNum);
        }
        throw new RcmException(text);
    }
}

