package org.lsst.ccs.drivers.parker;

import static org.lsst.ccs.drivers.parker.SystemUnsigned.*;

/**
 * Defines names and numbers for some system bits, that is, bits not associated
 * with a master, axis, program or encoder.
 * @author tether
 */
public enum SystemBit {
    
    /** Opto-isolated input #0 (pinout P4-1). */
    INPUT_LINE0(0, INPUT_LINES, 0),
    /** Opto-isolated input #1 (pinout P4-2). */
    INPUT_LINE1(1, INPUT_LINES, 1),
    /** Opto-isolated input #2 (pinout P4-3). */
    INPUT_LINE2(2, INPUT_LINES, 2),
    /** Opto-isolated input #3 (pinout P4-4). */
    INPUT_LINE3(3, INPUT_LINES, 3),
    /** Opto-isolated input #4 (pinout P4-5). */
    INPUT_LINE4(4, INPUT_LINES, 4),
    /** Opto-isolated input #5 (pinout P4-6). */
    INPUT_LINE5(5, INPUT_LINES, 5),
    /** Opto-isolated input #6 (pinout P4-7). */
    INPUT_LINE6(6, INPUT_LINES, 6),
    /** Opto-isolated input #7 (pinout P4-8). */
    INPUT_LINE7(7, INPUT_LINES, 7),
    /** Opto-isolated input #8 (pinout P4-9). */
    INPUT_LINE8(8, INPUT_LINES, 8),
    /** Opto-isolated input #9 (pinout P4-10). */
    INPUT_LINE9(9, INPUT_LINES, 9),
    /** Opto-isolated input #10 (pinout P4-11). */
    INPUT_LINE10(10, INPUT_LINES, 10),
    /** Opto-isolated input #11 (pinout P4-12). */
    INPUT_LINE11(11, INPUT_LINES, 11),
    /** Opto-isolated input #12 (pinout P4-13). */
    INPUT_LINE12(12, INPUT_LINES, 12),
    /** Opto-isolated input #13 (pinout P4-14). */
    INPUT_LINE13(13, INPUT_LINES, 13),
    /** Opto-isolated input #14 (pinout P4-15). */
    INPUT_LINE14(14, INPUT_LINES, 14),
    /** Opto-isolated input #15 (pinout P4-16). */
    INPUT_LINE15(15, INPUT_LINES, 15),
    
    /** Opto-isolated output #32 (pinout P3-1). */
    OUTPUT_LINE32(32, OUTPUT_LINES, 0),
    /** Opto-isolated output #33 (pinout P3-2). */
    OUTPUT_LINE33(33, OUTPUT_LINES, 1),
    /** Opto-isolated output #34 (pinout P3-3). */
    OUTPUT_LINE34(34, OUTPUT_LINES, 2),
    /** Opto-isolated output #35 (pinout P3-4). */
    OUTPUT_LINE35(35, OUTPUT_LINES, 3),
    /** Opto-isolated output #36 (pinout P3-5). */
    OUTPUT_LINE36(36, OUTPUT_LINES, 4),
    /** Opto-isolated output #37 (pinout P3-6). */
    OUTPUT_LINE37(37, OUTPUT_LINES, 5),
    /** Opto-isolated output #38 (pinout P3-7). */
    OUTPUT_LINE38(38, OUTPUT_LINES, 6),
    /** Opto-isolated output #39 (pinout P3-8). */
    OUTPUT_LINE39(39, OUTPUT_LINES, 7),
    /** Opto-isolated output #40 (pinout P3-9). */
    OUTPUT_LINE40(40, OUTPUT_LINES, 8),
    /** Opto-isolated output #41 (pinout P3-10). */
    OUTPUT_LINE41(41, OUTPUT_LINES, 9),
    /** Opto-isolated output #42 (pinout P3-11). */
    OUTPUT_LINE42(42, OUTPUT_LINES, 10),
    /** Opto-isolated output #43 (pinout P3-12). */
    OUTPUT_LINE43(43, OUTPUT_LINES, 11),
    /** Opto-isolated output #44 (pinout P3-13). */
    OUTPUT_LINE44(44, OUTPUT_LINES, 12),
    /** Opto-isolated output #45 (pinout P3-14). */
    OUTPUT_LINE45(45, OUTPUT_LINES, 13),
    /** Opto-isolated output #46 (pinout P3-15). */
    OUTPUT_LINE46(46, OUTPUT_LINES, 14),
    /** Opto-isolated output #47 (pinout P3-16). */
    OUTPUT_LINE47(47, OUTPUT_LINES, 15),
    
    /** (ACR90x0 and Aries) Is the sampling trigger armed? */
    SAMPLING_ARMED(104, ACR9000_MISC_OUTPUTS, 8),
    
    /** (ACR90x0 and Aries) Is sampling active at the moment? */
    SAMPLING_ACTIVE(105, ACR9000_MISC_OUTPUTS, 9),
    
    /** (ACR90x0 and Aries) Sample on trigger edge (rather than continuously
     * after the first trigger)? */
    SAMPLE_ON_EDGE(106, ACR9000_MISC_OUTPUTS, 10),

    /** User bit 0. */
    USER_BIT0(128, USER_FLAGS0, 0),
    /** User bit 1. */
    USER_BIT1(129, USER_FLAGS0, 1),
    /** User bit 2. */
    USER_BIT2(130, USER_FLAGS0, 2),
    /** User bit 3. */
    USER_BIT3(131, USER_FLAGS0, 3),
    /** User bit 4. */
    USER_BIT4(132, USER_FLAGS0, 4),
    /** User bit 5. */
    USER_BIT5(133, USER_FLAGS0, 5),
    /** User bit 6. */
    USER_BIT6(134, USER_FLAGS0, 6),
    /** User bit 7. */
    USER_BIT7(135, USER_FLAGS0, 7),
    /** User bit 8. */
    USER_BIT8(136, USER_FLAGS0, 8),
    /** User bit 9. */
    USER_BIT9(137, USER_FLAGS0, 9),
    /** User bit 10. */
    USER_BIT10(138, USER_FLAGS0, 10),
    /** User bit 11. */
    USER_BIT11(139, USER_FLAGS0, 11),
    /** User bit 12. */
    USER_BIT12(140, USER_FLAGS0, 12),
    /** User bit 13. */
    USER_BIT13(141, USER_FLAGS0, 13),
    /** User bit 14. */
    USER_BIT14(142, USER_FLAGS0, 14),
    /** User bit 15. */
    USER_BIT15(143, USER_FLAGS0, 15),

    /** (ACR90x0 and Aries) Print line numbers when listing programs? */
    SHOW_LINE_NUMBERS(5651, ACR9000_MISC_FLAGS1, 19);
    
    private final int indexNum;
    private final SystemUnsigned flagParameter;
    private final long bitMask;
    
    SystemBit(final int index, final SystemUnsigned flagParameter, final int bitIndex) {
        this.indexNum = index;
        this.flagParameter = flagParameter;
        this.bitMask = 1L << bitIndex;
    }
    
    /**
     * Gets the bit index used by the motor controller.
     * @return the index.
     */
    public int index() {return indexNum;}
    
    /**
     * Gets the string used to refer to the bit in AcroBasic.
     * @return the reference string.
     */
    public String reference() {return "BIT" + index();}
    
    /**
     * Gets the index of the flag parameter containing this bit.
     * @return the index.
     */
    public SystemUnsigned flagParameter() {return flagParameter;}
    
    /**
     * Gets the mask with a single 1 bit in the position assigned to this bit in the
     * associated flag parameter.
     * @return the mask.
     */
    public long flagParameterMask() {return bitMask;}
}
