package org.lsst.ccs.drivers.parker;

/**
 * Names and numbers some parameters associated with particular masters.
 * @author tether
 */
public enum MasterUnsigned {
    /** The first set of master flags. */
    PRIMARY_MASTER_FLAGS(4112, 1),
    
    /** The second set of master flags. */
    SECONDARY_MASTER_FLAGS(4344, 1),
    
    /** The third set of master flags. */
    TERTIARY_MASTER_FLAGS(4256, 1),
    
    /** The fourth set of master flags. */
    QUATERNARY_MASTER_FLAGS(4280, 1);
    
    private final int base;
    private final int step;
    
    MasterUnsigned(final int base, final int step) {
        this.base = base;
        this.step = step;
    }
    
    /**
     * Gets the index of this parameter for a given master.
     * @param master the master.
     * @return the parameter index.
     */
    public int index(final MasterName master) {return base + master.index() * step;}
    
    /**
     * Gets the string used to refer to the parameter for a given master in AcroBasic.
     * @param master the master.
     * @return the reference string.
     */
    public String reference(final MasterName master) {return "P" + index(master);}
}
