package org.lsst.ccs.drivers.parker;

/**
 * Defines names and numbers for axis parameters that are signed LONGs.
 * @author tether
 */
public enum AxisLong {
    
    /** Encoder position captured using the INTCAP command. */
    HARDWARE_CAPTURE(12292, 256);
    
    private final int base;
    
    private final int step;
    
    AxisLong(final int base, final int step) {
        this.base = base;
        this.step = step;
    }
    
    /**
     * Gets the controller's index for this parameter for a given axis.
     * @param axis the axis.
     * @return the index.
     */
    public int index(AxisName axis) {return base + axis.index() * step;}
    
    /**
     * Gets the AcroBasic string reference for this parameter for a given axis.
     * @param axis the axis.
     * @return the reference string.
     */
    public String reference(AxisName axis) {return "P" + index(axis);}
}
