/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.parker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.lsst.ccs.drivers.parker.AxisBit;
import org.lsst.ccs.drivers.parker.AxisLong;
import org.lsst.ccs.drivers.parker.AxisName;
import org.lsst.ccs.drivers.parker.AxisSingle;
import org.lsst.ccs.drivers.parker.AxisUnsigned;
import org.lsst.ccs.drivers.parker.ConnectionName;
import org.lsst.ccs.drivers.parker.ConnectionUnsigned;
import org.lsst.ccs.drivers.parker.ControllerType;
import org.lsst.ccs.drivers.parker.EncoderLong;
import org.lsst.ccs.drivers.parker.EncoderName;
import org.lsst.ccs.drivers.parker.LocalDouble;
import org.lsst.ccs.drivers.parker.LocalDoubleArray;
import org.lsst.ccs.drivers.parker.LocalLong;
import org.lsst.ccs.drivers.parker.LocalLongArray;
import org.lsst.ccs.drivers.parker.LocalSingle;
import org.lsst.ccs.drivers.parker.LocalSingleArray;
import org.lsst.ccs.drivers.parker.LocalString;
import org.lsst.ccs.drivers.parker.LocalStringArray;
import org.lsst.ccs.drivers.parker.MasterBit;
import org.lsst.ccs.drivers.parker.MasterName;
import org.lsst.ccs.drivers.parker.MasterUnsigned;
import org.lsst.ccs.drivers.parker.ProgramName;
import org.lsst.ccs.drivers.parker.SystemBit;
import org.lsst.ccs.drivers.parker.SystemUnsigned;
import org.lsst.ccs.drivers.parker.UserParameter;
import org.lsst.ccs.utilities.logging.Logger;

public final class AcrComm {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.parker");
    private static final int MANAGEMENT_PORT = 5004;
    private static final int BINARY_COMMAND_PORT = 5006;
    private static final int NO_TIMEOUT = 0;
    private static final int SHORT_TIMEOUT = 200;
    private static final int LONG_TIMEOUT = 2000;
    private final ControllerType ctrlType;
    private final Optional<PrintStream> out;
    private final Socket binSock;
    private final BufferedInputStream commandIn;
    private final BufferedOutputStream commandOut;
    private static final byte BINARY_GET_LONG = -120;
    private static final byte BINARY_SET_LONG = -119;
    private static final byte BINARY_GET_IEEE = -118;
    private static final byte BINARY_SET_IEEE = -117;
    private static final byte BINARY_PEEK = -112;
    private static final byte BINARY_POKE = -111;
    private static final byte BINARY_ADDRESS = -110;
    private static final byte BINARY_SET = 28;
    private static final byte BINARY_CLR = 29;
    private static final byte LONG_CONVERSION = 0;
    private static final byte FP64_CONVERSION = 1;
    private static final byte FP32_CONVERSION = 2;
    private static final byte DOUBLE_SCALAR = 0;
    private static final byte DOUBLE_ARRAY = 1;
    private static final byte SINGLE_SCALAR = 2;
    private static final byte SINGLE_ARRAY = 3;
    private static final byte LONG_SCALAR = 4;
    private static final byte LONG_ARRAY = 5;
    private static final byte STRING_SCALAR = 6;
    private static final byte STRING_ARRAY = 7;
    private static final int WORDS_PER_LONG = 1;
    private static final int WORDS_PER_SINGLE = 1;
    private static final int WORDS_PER_DOUBLE = 2;

    public static AcrComm newInstance(ControllerType ctrlType, String controllerHost, Optional<PrintStream> out) throws IOException {
        Socket binSock = null;
        try {
            binSock = new Socket(controllerHost, 5006);
            binSock.setSoTimeout(200);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        AcrComm comm = new AcrComm(ctrlType, out, binSock);
        comm.kick();
        return comm;
    }

    private AcrComm(ControllerType ctrlType, Optional<PrintStream> out, Socket binSock) throws IOException {
        this.ctrlType = ctrlType;
        this.out = out;
        this.binSock = binSock;
        this.commandIn = new BufferedInputStream(binSock.getInputStream());
        this.commandOut = new BufferedOutputStream(binSock.getOutputStream());
    }

    public void kick() {
        int leng = this.receiveAscii();
        if (leng == 0) {
            this.sendStr("VER");
        }
        int binPort = this.binSock.getLocalPort();
        byte[] ourIPaddress = this.binSock.getLocalAddress().getAddress();
        long intIPaddress = 0L;
        for (int j = 0; j < ourIPaddress.length; ++j) {
            intIPaddress = intIPaddress << 8 | (long)Byte.toUnsignedInt(ourIPaddress[j]);
        }
        for (ConnectionName conn : ConnectionName.values()) {
            long clientip;
            long port;
            long status = this.get(conn, ConnectionUnsigned.CONNECTION_STATUS);
            if (status != 1L && status != 2L || (long)binPort != (port = this.get(conn, ConnectionUnsigned.CLIENT_IP_PORT)) || intIPaddress != (clientip = this.get(conn, ConnectionUnsigned.CLIENT_IP_ADDRESS))) continue;
            log.info((Object)("Connected to stream " + this.get(conn, ConnectionUnsigned.STREAM_NUMBER)));
            this.out.ifPresent(console -> console.println("Connected to stream " + this.get(conn, ConnectionUnsigned.STREAM_NUMBER)));
            break;
        }
    }

    public void cleanup() {
        try {
            this.drain();
        }
        catch (RuntimeException e) {
            log.warning((Object)"Error draining binary command/response  socket during cleanup.", (Throwable)e);
        }
        try {
            this.binSock.close();
        }
        catch (IOException e) {
            log.warning((Object)"Error closing binary command/response socket.", (Throwable)e);
        }
    }

    public boolean get(AxisName axis, AxisBit axbit) {
        long value = this.get(axis, axbit.flagParameter());
        return (value & axbit.flagParameterMask()) != 0L;
    }

    public long get(AxisName axis, AxisUnsigned axunsigned) {
        return this.getUnsignedParameter(axunsigned.index(axis));
    }

    public long get(AxisName axis, AxisLong axlong) {
        return this.getLongParameter(axlong.index(axis));
    }

    public double get(AxisName axis, AxisSingle axsingle) {
        return this.getSingleParameter(axsingle.index(axis));
    }

    public long get(ConnectionName conn, ConnectionUnsigned connunsigned) {
        return this.getUnsignedParameter(connunsigned.index(conn));
    }

    public long get(EncoderName encoder, EncoderLong enclong) {
        return this.getLongParameter(enclong.index(encoder));
    }

    public double get(ProgramName program, LocalDouble locdouble) {
        long addr = this.localAddress(program.index(), (byte)0, 0, locdouble.index());
        return this.decodeSingles(this.peek(addr, 1, (byte)1))[0];
    }

    public double[] get(ProgramName program, LocalDoubleArray ldarray) {
        long addr = this.localAddress(program.index(), (byte)1, ldarray.index(), 0);
        int itemCount = this.arrayElementCount(addr, false);
        return this.decodeSingles(this.peek(addr, itemCount, (byte)1));
    }

    public long get(ProgramName program, LocalLong loclong) {
        long addr = this.localAddress(program.index(), (byte)4, 0, loclong.index());
        return this.decodeLongs(this.peek(addr, 1, (byte)0))[0];
    }

    public long[] get(ProgramName program, LocalLongArray llarray) {
        long addr = this.localAddress(program.index(), (byte)5, llarray.index(), 0);
        int wordCount = this.arrayElementCount(addr, false);
        return this.decodeLongs(this.peek(addr, wordCount, (byte)0));
    }

    public double get(ProgramName program, LocalSingle locsingle) {
        long addr = this.localAddress(program.index(), (byte)2, 0, locsingle.index());
        return this.decodeSingles(this.peek(addr, 1, (byte)2))[0];
    }

    public double[] get(ProgramName program, LocalSingleArray lsarray) {
        long addr = this.localAddress(program.index(), (byte)3, lsarray.index(), 0);
        int wordCount = this.arrayElementCount(addr, false);
        return this.decodeSingles(this.peek(addr, wordCount, (byte)2));
    }

    public String get(ProgramName program, LocalString locstring) {
        long addr = this.localAddress(program.index(), (byte)6, 0, locstring.index());
        int wordCount = this.stringActualWordCount(addr);
        return this.decodeStrings(wordCount, this.peek(addr, wordCount, (byte)0))[0];
    }

    public String[] get(ProgramName program, LocalStringArray lstrarray) {
        long addr = this.localAddress(program.index(), (byte)7, lstrarray.index(), 0);
        long[] metadata = this.decodeUnsigneds(this.peek(addr - (long)(2 * this.ctrlType.getWordBump()), 2, (byte)0));
        int wordsPerString = (int)((metadata[1] + 3L) / 4L);
        int stringCount = (int)metadata[0];
        return this.decodeStrings(wordsPerString, this.peek(addr, stringCount * wordsPerString, (byte)0));
    }

    public boolean get(MasterName master, MasterBit mbit) {
        long value = this.get(master, mbit.flagParameter());
        return (value & mbit.flagParameterMask()) != 0L;
    }

    public long get(MasterName master, MasterUnsigned munsigned) {
        return this.getUnsignedParameter(munsigned.index(master));
    }

    public boolean get(SystemBit sysbit) {
        long value = this.get(sysbit.flagParameter());
        return (value & sysbit.flagParameterMask()) != 0L;
    }

    public long get(SystemUnsigned sysul) {
        return this.getUnsignedParameter(sysul.index());
    }

    public double get(UserParameter uparam) {
        return this.decodeSingles(this.peek(this.globalAddress(uparam), 1, (byte)1))[0];
    }

    public void set(AxisName axis, AxisBit axbit, boolean value) {
        this.setOrClearBit(axbit.index(axis), value);
    }

    public void set(AxisName axis, AxisLong axlong, long value) {
        this.setLongParameter(axlong.index(axis), value);
    }

    public void set(AxisName axis, AxisSingle axsingle, double value) {
        this.setSingleParameter(axsingle.index(axis), value);
    }

    public void set(EncoderName encoder, EncoderLong enclong, long value) {
        this.setLongParameter(enclong.index(encoder), value);
    }

    public void set(ProgramName program, LocalDouble locdouble, double value) {
        long addr = this.localAddress(program.index(), (byte)0, 0, locdouble.index());
        this.poke(addr, (byte)1, this.encodeSingles(value));
    }

    public void set(ProgramName program, LocalDoubleArray ldarray, double[] value) {
        long addr = this.localAddress(program.index(), (byte)1, ldarray.index(), 0);
        this.checkElementCount(addr, false, value.length);
        this.poke(addr, (byte)1, this.encodeSingles(value));
    }

    public void set(ProgramName program, LocalLong loclong, long value) {
        long addr = this.localAddress(program.index(), (byte)4, 0, loclong.index());
        this.poke(addr, (byte)0, this.encodeLongs(value));
    }

    public void set(ProgramName program, LocalLongArray llarray, long[] value) {
        long addr = this.localAddress(program.index(), (byte)5, llarray.index(), 0);
        this.checkElementCount(addr, false, value.length);
        this.poke(addr, (byte)0, this.encodeLongs(value));
    }

    public void set(ProgramName program, LocalSingle locsingle, double value) {
        long addr = this.localAddress(program.index(), (byte)2, 0, locsingle.index());
        this.poke(addr, (byte)2, this.encodeSingles(value));
    }

    public void set(ProgramName program, LocalSingleArray lsarray, double[] value) {
        long addr = this.localAddress(program.index(), (byte)3, lsarray.index(), 0);
        this.checkElementCount(addr, false, value.length);
        this.poke(addr, (byte)2, this.encodeSingles(value));
    }

    public void set(ProgramName program, LocalString locstring, String value) {
        long arrayAddr = this.localAddress(program.index(), (byte)6, 0, 0);
        long[] metadata = this.decodeUnsigneds(this.peek(arrayAddr - (long)(2 * this.ctrlType.getWordBump()), 2, (byte)0));
        if ((long)value.length() > metadata[1]) {
            throw new IllegalArgumentException("Attempt to overfill an AcroBAsic string.");
        }
        long addr = this.localAddress(program.index(), (byte)6, 0, locstring.index());
        this.poke(addr, (byte)0, this.encodeStrings((value.length() + 3) / 4 + 1, value));
    }

    public void set(ProgramName program, LocalStringArray lstrarray, String[] value) {
        long[] metadata;
        long addr = this.localAddress(program.index(), (byte)7, lstrarray.index(), 0);
        int maxSize = Arrays.stream(value).mapToInt(String::length).max().getAsInt();
        if ((long)maxSize > (metadata = this.decodeUnsigneds(this.peek(addr - (long)(2 * this.ctrlType.getWordBump()), 2, (byte)0)))[1]) {
            throw new IllegalArgumentException("Attempt to overfill an AcroBasic string.");
        }
        if ((long)value.length > metadata[0]) {
            throw new IllegalArgumentException("Attempt to overfill an AcroBasic array.");
        }
        int wordsPerString = 1 + ((int)metadata[1] + 3) / 4;
        this.poke(addr, (byte)0, this.encodeStrings(wordsPerString, value));
    }

    public void set(MasterName master, MasterBit mbit, boolean value) {
        this.setOrClearBit(mbit.index(master), value);
    }

    public void set(SystemBit sysbit, boolean value) {
        this.setOrClearBit(sysbit.index(), value);
    }

    public void set(SystemUnsigned sysul, long value) {
        this.setUnsignedParameter(sysul.index(), value);
    }

    public void set(UserParameter uparam, double ... value) {
        this.poke(this.globalAddress(uparam), (byte)1, this.encodeSingles(value));
    }

    public long globalAddress(UserParameter uparam) {
        long globalBase = this.decodeUnsigneds(this.peek(this.ctrlType.getSystemPointerAddress(), 1, (byte)0))[0];
        long wbump = this.ctrlType.getWordBump();
        return globalBase + wbump * (long)(1 + 2 * uparam.index());
    }

    public long localAddress(int programNumber, byte typeCode, int arrayNumber, int arrayIndex) {
        long wordBump = this.ctrlType.getWordBump();
        long elementBump = 0L;
        int elementCount = 0;
        long[] metadata = null;
        byte[] command = new byte[]{0, -110, (byte)programNumber, typeCode};
        this.sendBinary(command);
        byte[] response = this.receiveBinary(command.length + 4);
        long addr = this.decodeUnsigneds(response)[1];
        if ((typeCode & 1) != 0) {
            metadata = this.decodeUnsigneds(this.peek(addr, 1, (byte)0));
            elementCount = (int)metadata[0];
            elementBump = wordBump;
            if (arrayNumber < 0 || arrayNumber >= elementCount) {
                throw new IllegalArgumentException("No such array was declared.");
            }
            addr += wordBump + elementBump * (long)arrayNumber;
            addr = this.decodeUnsigneds(this.peek(addr, 1, (byte)0))[0];
        }
        switch (typeCode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                metadata = this.decodeUnsigneds(this.peek(addr, 1, (byte)0));
                elementBump = wordBump;
                break;
            }
            case 0: 
            case 1: {
                metadata = this.decodeUnsigneds(this.peek(addr, 1, (byte)0));
                elementBump = 2L * wordBump;
                break;
            }
            case 6: 
            case 7: {
                metadata = this.decodeUnsigneds(this.peek(addr, 2, (byte)0));
                elementBump = wordBump * (metadata[1] + 3L) / 4L;
            }
        }
        elementCount = (int)metadata[0];
        addr += wordBump * (long)metadata.length;
        if (arrayIndex < 0 || arrayIndex >= elementCount) {
            throw new ArrayIndexOutOfBoundsException("No such scalar or array element.");
        }
        return addr + (long)arrayIndex * elementBump;
    }

    public long getUnsignedParameter(int parameterIndex) {
        return this.decodeUnsigneds(this.getParameterBytes(parameterIndex, (byte)-120))[0];
    }

    public void setUnsignedParameter(int parameterIndex, long value) {
        this.setParameterBytes(parameterIndex, (byte)-119, this.encodeUnsigneds(value));
    }

    public long getLongParameter(int parameterIndex) {
        return this.decodeLongs(this.getParameterBytes(parameterIndex, (byte)-120))[0];
    }

    public void setLongParameter(int parameterIndex, long value) {
        this.setParameterBytes(parameterIndex, (byte)-119, this.encodeLongs(value));
    }

    public double getSingleParameter(int parameterIndex) {
        return this.decodeSingles(this.getParameterBytes(parameterIndex, (byte)-118))[0];
    }

    public void setSingleParameter(int parameterIndex, double value) {
        this.setParameterBytes(parameterIndex, (byte)-117, this.encodeSingles(value));
    }

    private byte[] getParameterBytes(int parameterIndex, byte commandCode) {
        byte[] command = new byte[]{0, commandCode, (byte)parameterIndex, (byte)(parameterIndex >> 8)};
        this.sendBinary(command);
        byte[] response = this.receiveBinary(command.length + 4);
        return Arrays.copyOfRange(response, command.length, response.length);
    }

    private void setParameterBytes(int parameterIndex, byte commandCode, byte[] encodedValue) {
        byte[] command = new byte[]{0, commandCode, (byte)parameterIndex, (byte)(parameterIndex >> 8), encodedValue[0], encodedValue[1], encodedValue[2], encodedValue[3]};
        this.sendBinary(command);
    }

    public void setOrClearBit(int bitIndex, boolean value) {
        byte[] command = new byte[]{value ? (byte)28 : 29, (byte)bitIndex, (byte)(bitIndex >> 8), 0};
        this.sendBinary(command);
    }

    private void checkElementCount(long firstElementAddress, boolean isString, int newElementCount) {
        int maxElements = this.arrayElementCount(firstElementAddress, isString);
        if (newElementCount > maxElements) {
            throw new IllegalArgumentException("Attempt to overfill an AcroBasic array.");
        }
    }

    private int arrayElementCount(long firstElementAddress, boolean isString) {
        long countAddress = firstElementAddress - (long)(this.ctrlType.getWordBump() * (isString ? 2 : 1));
        return (int)this.decodeUnsigneds(this.peek(countAddress, 1, (byte)0))[0];
    }

    private int stringActualWordCount(long address) {
        int byteCount = (int)this.decodeUnsigneds(this.peek(address, 1, (byte)0))[0];
        return 1 + (byteCount + 3) / 4;
    }

    public byte[] encodeUnsigneds(long ... value) {
        byte[] result = new byte[4 * value.length];
        int i = 0;
        for (long v : value) {
            result[i++] = (byte)v;
            result[i++] = (byte)(v >> 8);
            result[i++] = (byte)(v >> 16);
            result[i++] = (byte)(v >> 24);
        }
        return result;
    }

    public long[] decodeUnsigneds(byte ... value) {
        long[] result = new long[(value.length + 3) / 4];
        int i = 0;
        int shift = 0;
        long r = 0L;
        for (byte v : value) {
            r |= Byte.toUnsignedLong(v) << shift;
            if ((shift += 8) < 32) continue;
            shift = 0;
            result[i++] = r;
            r = 0L;
        }
        if (shift != 0) {
            result[i++] = r;
        }
        return result;
    }

    public byte[] encodeLongs(long ... value) {
        return this.encodeUnsigneds(value);
    }

    public long[] decodeLongs(byte ... value) {
        long[] result = new long[(value.length + 3) / 4];
        int i = 0;
        int shift = 0;
        long r = 0L;
        for (byte v : value) {
            r |= (shift == 24 ? (long)v : (long)v & 0xFFL) << shift;
            if ((shift += 8) < 32) continue;
            shift = 0;
            result[i++] = r;
            r = 0L;
        }
        if (shift != 0) {
            result[i++] = r;
        }
        return result;
    }

    public byte[] encodeSingles(double ... value) {
        long[] asLong = new long[value.length];
        int i = 0;
        for (double v : value) {
            asLong[i++] = Float.floatToIntBits((float)v);
        }
        return this.encodeUnsigneds(asLong);
    }

    public double[] decodeSingles(byte ... value) {
        if (value.length % 4 != 0) {
            throw new IllegalArgumentException("decodeSingles() needs a multiple of four bytes.");
        }
        long[] asLong = this.decodeUnsigneds(value);
        double[] result = new double[asLong.length];
        int i = 0;
        for (long al : asLong) {
            result[i++] = Float.intBitsToFloat((int)al);
        }
        return result;
    }

    public byte[] encodeDoubles(double ... value) {
        long[] asLong = new long[2 * value.length];
        int i = 0;
        for (double v : value) {
            long l = Double.doubleToLongBits(v);
            asLong[i++] = l & 0xFFFFFFFFL;
            asLong[i++] = l >>> 32;
        }
        return this.encodeUnsigneds(asLong);
    }

    public double[] decodeDoubles(byte ... value) {
        if (value.length % 8 != 0) {
            throw new IllegalArgumentException("decodeDoubles() needs a multiple of 8 bytes.");
        }
        long[] asLong = this.decodeUnsigneds(value);
        double[] result = new double[asLong.length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.longBitsToDouble(asLong[2 * i + 1] << 32 | asLong[2 * i]);
        }
        return result;
    }

    public byte[] encodeStrings(int elementWordCount, String ... value) {
        int elementByteCount = 4 * elementWordCount;
        byte[] result = new byte[elementByteCount * value.length];
        Arrays.fill(result, (byte)0);
        int resultNext = 0;
        for (String v : value) {
            byte[] byteCount = this.encodeUnsigneds(v.length());
            byte[] stringBytes = v.getBytes(StandardCharsets.ISO_8859_1);
            System.arraycopy(byteCount, 0, result, resultNext, byteCount.length);
            System.arraycopy(stringBytes, 0, result, resultNext + byteCount.length, stringBytes.length);
            resultNext += elementByteCount;
        }
        return result;
    }

    public String[] decodeStrings(int elementWordCount, byte ... value) {
        ArrayList<String> result = new ArrayList<String>();
        int elementByteCount = 4 * elementWordCount;
        for (int i = 0; i < value.length; i += elementByteCount + 4) {
            int byteCount = (int)this.decodeUnsigneds(value[i], value[i + 1], value[i + 2], value[i + 3])[0];
            result.add(new String(Arrays.copyOfRange(value, i + 4, i + 4 + byteCount), StandardCharsets.ISO_8859_1));
        }
        return result.toArray(new String[0]);
    }

    public byte[] peek(long address, int wordCount, byte conversion) {
        byte[] result = new byte[4 * wordCount];
        int resultNext = 0;
        while (wordCount > 0) {
            int n = Math.min(wordCount, 255);
            long header = Byte.toUnsignedLong((byte)-112) << 8 | Byte.toUnsignedLong(conversion) << 16 | Integer.toUnsignedLong(n) << 24;
            byte[] command = this.encodeUnsigneds(header, address);
            this.sendBinary(command);
            byte[] response = this.receiveBinary(command.length + 4 * n);
            System.arraycopy(response, command.length, result, resultNext, response.length - command.length);
            resultNext += response.length - command.length;
            wordCount -= n;
            address += (long)(n * this.ctrlType.getWordBump());
        }
        return result;
    }

    public void poke(long address, byte conversion, byte ... value) {
        if (value.length % 4 != 0) {
            throw new IllegalArgumentException("The byte count for poke() is not a multiple of four.");
        }
        int valueNext = 0;
        int wordCount = value.length / 4;
        while (wordCount > 0) {
            int n = Math.min(wordCount, 255);
            byte[] command = new byte[8 + 4 * n];
            long header = Byte.toUnsignedLong((byte)-111) << 8 | Byte.toUnsignedLong(conversion) << 16 | Integer.toUnsignedLong(n) << 24;
            System.arraycopy(this.encodeUnsigneds(header, address), 0, command, 0, 8);
            System.arraycopy(value, valueNext, command, 8, 4 * n);
            this.sendBinary(command);
            valueNext += 4 * n;
            wordCount -= n;
            address += (long)(n * this.ctrlType.getWordBump());
        }
    }

    public void sendFile(String fName, boolean echo) {
        try (Stream<String> stream = Files.lines(Paths.get(fName, new String[0]));){
            if (echo) {
                this.sendStr("echo 0");
            }
            stream.forEachOrdered(line -> this.sendStr((String)line));
        }
        catch (IOException exc) {
            throw new Exception(exc);
        }
        finally {
            this.sendStr("echo 1");
        }
    }

    public int sendStr(String cmnd) {
        byte[] data = cmnd.getBytes(StandardCharsets.US_ASCII);
        try {
            this.commandOut.write(data);
            this.commandOut.write("\r".getBytes(StandardCharsets.US_ASCII));
            int nsent = data.length + 1;
            while (nsent % 4 != 0) {
                this.commandOut.write(0);
                ++nsent;
            }
            this.commandOut.flush();
            this.logStr(cmnd);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return this.receiveAscii();
    }

    public int receiveAscii() {
        IOException savedExc = null;
        StringBuilder builder = new StringBuilder();
        int ch = 0;
        int count = 0;
        try {
            while ((ch = this.commandIn.read()) >= 0) {
                builder.append((char)ch);
                ++count;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException exc) {
            savedExc = exc;
        }
        String collected = builder.toString();
        this.out.ifPresent(console -> console.println(collected));
        this.logAscii(collected);
        if (savedExc != null) {
            throw new Exception(savedExc);
        }
        return ch < 0 ? -1 : count;
    }

    public void sendBinary(byte[] cmnd) {
        try {
            this.commandOut.write(cmnd, 0, cmnd.length);
            this.commandOut.flush();
            this.logBin(true, cmnd, cmnd.length);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    public byte[] receiveBinary(int leng) {
        int offs;
        int nRead;
        byte[] buff = new byte[leng];
        for (offs = 0; offs < leng; offs += nRead) {
            try {
                nRead = this.commandIn.read(buff, offs, leng - offs);
                if (nRead >= 0) continue;
                throw new IOException("Premature EOF on binary receive.");
            }
            catch (SocketTimeoutException e) {
                throw new Exception(e);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        this.logBin(false, buff, offs);
        return buff;
    }

    public void drain() {
        if (this.binSock == null) {
            return;
        }
        try {
            byte[] buff = new byte[64];
            int nRead = 1;
            while (nRead > 0) {
                nRead = this.commandIn.read(buff, 0, buff.length);
                if (nRead <= 0) continue;
                this.logBin(false, buff, 0);
            }
        }
        catch (SocketTimeoutException buff) {
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    private void logBin(boolean sent, byte[] buff, int leng) {
        if (log.isDebugEnabled()) {
            int bytesPerGroup = 4;
            int bytesPerLine = 32;
            StringBuilder display = new StringBuilder(sent ? "cmnd\n" : "resp\n");
            for (int j = 0; j < leng; ++j) {
                display.append(String.format("%02x", buff[j]));
                if (j % 32 == 31) {
                    display.append("\n");
                    continue;
                }
                if (j % 4 != 3) continue;
                display.append(" ");
            }
            if (leng % 32 != 0) {
                display.append("\n");
            }
            log.debug((Object)display.toString());
        }
    }

    private void logAscii(String text) {
        log.debug((Object)text);
        if (!text.endsWith("\n")) {
            log.debug((Object)"\n");
        }
    }

    private void logStr(String cmnd) {
        log.debug((Object)("Asc cmnd: " + cmnd));
    }

    public static class Exception
    extends RuntimeException {
        public Exception(Throwable e) {
            super(e);
        }
    }
}

