/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.orielshutter;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class OrielShutter
extends Ascii {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r";
    private int timeout = 1000;
    private int addrOffset = 0;

    public void open(String serialname, int port, int addr) throws DriverException {
        this.init();
        this.addrOffset = addr;
        this.open(2, serialname, port);
    }

    public void openftdi(String serialname, int baud, int addr) throws DriverException {
        this.init();
        System.out.println("opening connection to the Oriel Shutter");
        this.addrOffset = addr;
        this.open(1, serialname, baud);
    }

    public void init() {
        this.setTerminator(this.terminator);
    }

    public void close() throws DriverException {
        this.close();
    }

    public void reset() throws DriverException {
        this.writeOrielShutter("RST");
    }

    public String getIdent() throws DriverException {
        return this.readOrielShutter("IDN?");
    }

    public void openShutter() throws DriverException {
        this.writeOrielShutter(String.valueOf(64 + this.addrOffset));
    }

    public void closeShutter() throws DriverException {
        this.writeOrielShutter(String.valueOf(65 + this.addrOffset));
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeOrielShutter(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readOrielShutter() throws DriverException {
        return this.read();
    }

    public synchronized String readOrielShutter(String command) throws DriverException {
        this.writeOrielShutter(command);
        return this.readOrielShutter();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

