/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.command.AllowedValuesProvider;
import org.lsst.ccs.command.DictionaryArgument;

class MethodBasedDictionaryArgument
implements DictionaryArgument {
    private final String name;
    private final String description;
    private final String type;
    private final String simpleType;
    private final String defaultValue;
    private final List<String> values = new ArrayList<String>();
    private AllowedValuesProvider allowedValuesProvider = null;
    private static final long serialVersionUID = -94438408862305319L;

    MethodBasedDictionaryArgument(String name, Class type, String description, String defaultValue) {
        this.name = name;
        this.type = type.getCanonicalName();
        this.simpleType = type.getSimpleName();
        if (type.isEnum()) {
            Enum[] enums;
            Enum[] enumArray = enums = (Enum[])type.getEnumConstants();
            int n = enums.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                this.values.add(e.name().toLowerCase());
                ++n2;
            }
        }
        this.defaultValue = !defaultValue.equals("***NULL_VALUE_FOR_COMMAND_ARGUMENT***") ? defaultValue : null;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSimpleType() {
        return this.simpleType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getAllowedValues() {
        if (this.allowedValuesProvider != null) {
            List<String> allowedValues = this.allowedValuesProvider.getAllowedValues();
            return allowedValues == null ? Collections.emptyList() : allowedValues;
        }
        return this.values;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    void setAllowedValuesProvder(AllowedValuesProvider provider) {
        this.allowedValuesProvider = provider;
    }
}

