/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class ClasspathUtilities {
    public static void setFullSystemClasspathInSystemProperty(String property) {
        StringBuffer appPath = new StringBuffer();
        URL[] urls = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        HashMap<String, String> jarFilesFullPathHash = new HashMap<String, String>();
        for (int i = 0; i < urls.length; ++i) {
            try {
                URI uri = new URI(urls[i].toExternalForm());
                File file = new File(uri.normalize());
                jarFilesFullPathHash.put(file.getName(), file.getAbsolutePath());
                try {
                    JarFile jar = new JarFile(file);
                    Manifest manifest = jar.getManifest();
                    String manifestClassPath = null;
                    try {
                        manifestClassPath = manifest.getMainAttributes().getValue("Class-Path").trim();
                    }
                    catch (NullPointerException x) {
                        // empty catch block
                    }
                    File parentDir = file.getParentFile();
                    if (manifestClassPath == null) continue;
                    StringTokenizer classPathTokens = new StringTokenizer(manifestClassPath, " ");
                    while (classPathTokens.hasMoreTokens()) {
                        String manifestClassPathJar = classPathTokens.nextToken();
                        File cpEntry = new File(parentDir, manifestClassPathJar);
                        if (!cpEntry.exists() || jarFilesFullPathHash.containsKey(manifestClassPathJar)) continue;
                        jarFilesFullPathHash.put(manifestClassPathJar, cpEntry.getAbsolutePath());
                    }
                    continue;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            catch (URISyntaxException x) {
                x.printStackTrace();
            }
        }
        Iterator keysIter = jarFilesFullPathHash.keySet().iterator();
        while (keysIter.hasNext()) {
            String jarFullPath = (String)jarFilesFullPathHash.get(keysIter.next());
            appPath.append(jarFullPath);
            if (!keysIter.hasNext()) continue;
            appPath.append(File.pathSeparatorChar);
        }
        System.setProperty(property, appPath.toString());
    }
}

