/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.Ftdi;

public class TalkFtdi {
    private static final PrintStream out = System.out;
    private static final String[] terms = new String[]{"", "\r\n", "\r", "\n"};
    private final Thread readW = new Thread(new Reader());
    private final Ftdi ftd = new Ftdi();
    private int nRead = 0;
    private int nByte = 0;
    private boolean open;

    public static void main(String[] args) {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser(optns);
        try {
            parser.parseArgument(args);
            if (optns.showHelp) {
                TalkFtdi.showHelp(parser);
            } else {
                new TalkFtdi().run(optns);
            }
        }
        catch (CmdLineException e) {
            if (!optns.showHelp) {
                out.println(e.getMessage());
            }
            TalkFtdi.showHelp(parser);
        }
        catch (Exception e) {
            out.println(e.getMessage());
        }
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.ftd.open(optns.node, optns.index, optns.serial);
        this.ftd.setBaudrate(optns.baud);
        int dataBits = optns.dataBits7 && !optns.dataBits8 ? 7 : 8;
        int stopBits = optns.stopBits2 && !optns.stopBits1 ? 2 : 0;
        this.ftd.setDataCharacteristics(dataBits, stopBits, optns.parity.getValue());
        this.ftd.setFlowControl(optns.flow.getValue());
        this.ftd.enableEvents(1);
        this.open = true;
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        String term = terms[optns.term.ordinal()];
        out.println("Connected. Type CTRL-D to exit, CR for read stats.");
        while ((line = readC.readLine("")) != null) {
            if (line.equals("")) {
                out.format("#reads: %s; #bytes: %s\n", this.nRead, this.nByte);
                continue;
            }
            this.ftd.write((String.valueOf(line) + term).getBytes());
        }
        this.open = false;
        this.ftd.close();
    }

    private static void showHelp(CmdLineParser parser) {
        out.println("Usage: TalkFtdi [options...]");
        out.println("Options:");
        parser.printUsage(out);
    }

    static enum Flow {
        N(0),
        R(256),
        D(512),
        X(1024);

        int value;

        private Flow(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    private static class Options {
        @Option(name="-n", metaVar="<node>", usage="The network node running an FTDI server (default: local device)")
        private String node;
        @Option(name="-s", metaVar="<serial>", usage="The (partial) serial number of the device (default: match all)")
        private String serial;
        @Option(name="-i", metaVar="<index>", usage="Index in the list of matching devices (default 0)")
        private int index = 0;
        @Option(name="-b", metaVar="<baudRate>", usage="Baud rate (default 115200)")
        private int baud = 115200;
        @Option(name="-p", metaVar="<parity>", usage="Parity: n(one) (default), o(dd), e(ven), m(ark) or s(pace)")
        private Parity parity = Parity.N;
        @Option(name="-d8", usage="Eight data bits (default)")
        private boolean dataBits8;
        @Option(name="-d7", usage="Seven data bits")
        private boolean dataBits7;
        @Option(name="-s1", usage="One stop bit (default)")
        private boolean stopBits1;
        @Option(name="-s2", usage="Two stop bits")
        private boolean stopBits2;
        @Option(name="-f", metaVar="<flow>", usage="Flow control: n(one) (default), r(ts/cts), d(tr/dsr) or x(on/off)")
        private Flow flow = Flow.N;
        @Option(name="-t", metaVar="<term>", usage="Sent line terminator: none, crlf, cr or lf (default)")
        private Terminator term = Terminator.LF;
        @Option(name="-help", usage="Display this help")
        private boolean showHelp;

        private Options() {
        }
    }

    static enum Parity {
        N(0),
        O(1),
        E(2),
        M(3),
        S(4);

        int value;

        private Parity(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    private class Reader
    implements Runnable {
        byte[] data = new byte[1024];

        private Reader() {
        }

        @Override
        public void run() {
            while (true) {
                int leng = 0;
                try {
                    leng = TalkFtdi.this.ftd.getQueueStatus();
                    if (leng == 0) {
                        TalkFtdi.this.ftd.awaitEvent(0);
                        leng = TalkFtdi.this.ftd.getQueueStatus();
                    }
                    if (leng > this.data.length) {
                        leng = this.data.length;
                    }
                    if (!TalkFtdi.this.open) break;
                    leng = TalkFtdi.this.ftd.read(this.data, 0, leng);
                }
                catch (DriverException e) {
                    if (!TalkFtdi.this.open) break;
                    out.println((Object)e);
                    break;
                }
                out.write(this.data, 0, leng);
                TalkFtdi talkFtdi = TalkFtdi.this;
                talkFtdi.nRead = talkFtdi.nRead + 1;
                TalkFtdi talkFtdi2 = TalkFtdi.this;
                talkFtdi2.nByte = talkFtdi2.nByte + leng;
            }
        }
    }

    private static enum Terminator {
        NONE,
        CRLF,
        CR,
        LF;

    }
}

