/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.drivers.modbus.ModbusException;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestModbus
implements CmndProcess.Dispatch {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_COILREAD = 2;
    private static final int CMD_DISCREAD = 3;
    private static final int CMD_REGREAD = 4;
    private static final int CMD_INPREAD = 5;
    private static final int CMD_COILWRITE = 6;
    private static final int CMD_REGWRITE = 7;
    private static final int CMD_SHOWMODEM = 8;
    private static final int NUM_CMDS = 9;
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<index>] [<serial>] [<addr>] [<node>]", "index   The index of the FTDI device to connect to (default 0)", "serial  The serial number of the FTDI device (default none)", "addr    The Modbus address of the device (default 1)", "node    The node from which Modbus is being served (default local)"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpCoilread = new String[]{"Reads and displays a set of coils", "coilread <nmbr> [<count>]", "nmbr   The number of the first coil to read", "count  The number of coils to read (default 1)"};
    private static final String[] helpDiscread = new String[]{"Reads and displays a set of discrete inputs", "discread <nmbr> [<count>]", "nmbr   The number of the first discrete input to read", "count  The number of discrete inputs to read (default 1)"};
    private static final String[] helpRegread = new String[]{"Reads and displays a set of holding registers", "regread <nmbr> [<count>]", "nmbr   The number of the first holding register to read", "count  The number of holding registers to read (default 1)"};
    private static final String[] helpInpread = new String[]{"Reads and displays a set of input registers", "regread <nmbr> [<count>]", "nmbr   The number of the first input register to read", "count  The number of input registers to read (default 1)"};
    private static final String[] helpCoilwrite = new String[]{"Writes a set of coils", "coilwrite <nmbr> <value1> [<value2>] ... [<value8>]", "nmbr    The number of the first coil to write", "valuen  The nth value to write, 0 (off), ~0 (on)"};
    private static final String[] helpRegwrite = new String[]{"Writes a set of holding registers", "regwrite <nmbr> <value1> [<value2>] ... [<value8>]", "nmbr    The number of the first holding register to write", "valuen  The nth value to write"};
    private static final String[] helpShowmodem = new String[]{"Displays the status of the modem lines", "showmodem"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(9);
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private Modbus mod = new Modbus();
    private short busAddr;
    private boolean devOpen;

    static {
        cmnd.add("open", 0, helpOpen, "isws", new CmndProcess.Lookup[0]);
        cmnd.add("close", 1, helpClose, "", new CmndProcess.Lookup[0]);
        cmnd.add("coilread", 2, helpCoilread, "Ww", new CmndProcess.Lookup[0]);
        cmnd.add("discread", 3, helpDiscread, "Ww", new CmndProcess.Lookup[0]);
        cmnd.add("regread", 4, helpRegread, "Ww", new CmndProcess.Lookup[0]);
        cmnd.add("inpread", 5, helpInpread, "Ww", new CmndProcess.Lookup[0]);
        cmnd.add("coilwrite", 6, helpCoilwrite, "WWwwwwwww", new CmndProcess.Lookup[0]);
        cmnd.add("regwrite", 7, helpRegwrite, "WWwwwwwww", new CmndProcess.Lookup[0]);
        cmnd.add("showmodem", 8, helpShowmodem, "", new CmndProcess.Lookup[0]);
        out = System.out;
    }

    public static void main(String[] args) {
        new TestModbus().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
            if (this.devOpen) {
                this.mod.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procOpen(found, args);
                    break;
                }
                case 1: {
                    this.procClose(found, args);
                    break;
                }
                case 2: {
                    this.procCoilread(found, args);
                    break;
                }
                case 3: {
                    this.procDiscread(found, args);
                    break;
                }
                case 4: {
                    this.procRegread(found, args);
                    break;
                }
                case 5: {
                    this.procInpread(found, args);
                    break;
                }
                case 6: {
                    this.procCoilwrite(found, args);
                    break;
                }
                case 7: {
                    this.procRegwrite(found, args);
                    break;
                }
                case 8: {
                    this.procShowmodem(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (ModbusException e) {
            out.println(e);
        }
        return true;
    }

    private void procOpen(int found, Object[] args) throws ModbusException {
        int index = (found & 1) != 0 ? (Integer)args[0] : 0;
        String serial = (found & 2) != 0 ? (String)args[1] : null;
        String node = (found & 8) != 0 ? (String)args[3] : null;
        this.mod.open(node, index, serial);
        this.devOpen = true;
        this.busAddr = (found & 4) != 0 ? (Short)args[2] : (short)1;
    }

    private void procClose(int found, Object[] args) throws ModbusException {
        this.devOpen = false;
        this.mod.close();
    }

    private void procCoilread(int found, Object[] args) throws ModbusException {
        short addr = (Short)args[0];
        int count = (found & 2) != 0 ? (Short)args[1] : 1;
        byte[] reply = this.mod.readCoils(this.busAddr, addr, (short)count);
        int nvalue = count <= 8 * reply.length ? count : 8 * reply.length;
        int j = 0;
        while (j < nvalue) {
            if (j % 20 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%4s:", addr + j);
            }
            out.format("%2s", (reply[j >> 3] & 1 << (j & 7)) != 0 ? 1 : 0);
            ++j;
        }
        out.println();
    }

    private void procDiscread(int found, Object[] args) throws ModbusException {
        short nmbr = (Short)args[0];
        int count = (found & 2) != 0 ? (Short)args[1] : 1;
        byte[] reply = this.mod.readDiscretes(this.busAddr, nmbr, (short)count);
        int nvalue = count <= 8 * reply.length ? count : 8 * reply.length;
        int j = 0;
        while (j < nvalue) {
            if (j % 20 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%4s:", nmbr + j);
            }
            out.format("%2s", (reply[j >> 3] & 1 << (j & 7)) != 0 ? 1 : 0);
            ++j;
        }
        out.println();
    }

    private void procRegread(int found, Object[] args) throws ModbusException {
        short nmbr = (Short)args[0];
        short count = (found & 2) != 0 ? (Short)args[1] : (short)1;
        short[] reply = this.mod.readRegisters(this.busAddr, nmbr, count);
        int j = 0;
        while (j < reply.length) {
            if (j % 10 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%4s:", nmbr + j);
            }
            out.format(" %04x", reply[j]);
            ++j;
        }
        out.println();
    }

    private void procInpread(int found, Object[] args) throws ModbusException {
        short nmbr = (Short)args[0];
        short count = (found & 2) != 0 ? (Short)args[1] : (short)1;
        short[] reply = this.mod.readInputs(this.busAddr, nmbr, count);
        int j = 0;
        while (j < reply.length) {
            if (j % 10 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%4s:", nmbr + j);
            }
            out.format(" %04x", reply[j]);
            ++j;
        }
        out.println();
    }

    private void procCoilwrite(int found, Object[] args) throws ModbusException {
        short nmbr = (Short)args[0];
        short count = 0;
        int value = 0;
        int j = 0;
        while (j < 8) {
            if ((found & 2) != 0) {
                if ((Short)args[j + 1] != 0) {
                    value = (short)(value | 1 << count);
                }
                count = (short)(count + 1);
            }
            ++j;
            found >>= 1;
        }
        if (count == 1) {
            this.mod.writeCoil(this.busAddr, nmbr, value != 0);
        } else {
            this.mod.writeCoils(this.busAddr, nmbr, count, new byte[]{(byte)value});
        }
    }

    private void procRegwrite(int found, Object[] args) throws ModbusException {
        short nmbr = (Short)args[0];
        int count = 0;
        short[] value = new short[8];
        int j = 0;
        while (j < 8) {
            if ((found & 2) != 0) {
                int n = count;
                count = (short)(n + 1);
                value[n] = (Short)args[j + 1];
            }
            ++j;
            found >>= 1;
        }
        if (count == 1) {
            this.mod.writeRegister(this.busAddr, nmbr, value[0]);
        } else {
            short[] values = new short[count];
            System.arraycopy(value, 0, values, 0, count);
            this.mod.writeRegisters(this.busAddr, nmbr, values);
        }
    }

    private void procShowmodem(int found, Object[] args) throws ModbusException {
        try {
            Ftdi ftd = this.mod.getFtdi();
            int status = ftd.getModemStatus();
            out.format("Modem status: 0x%04x\n", status);
        }
        catch (FtdiException e) {
            throw new ModbusException(e.getMessage());
        }
    }
}

