/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import org.lsst.ccs.drivers.lighthouse.ChannelType;
import org.lsst.ccs.drivers.lighthouse.ChannelUnits;

public enum DataChannel {
    COUNTER_0_3(0, "0.3", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_0_5(1, "0.5", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_1_0(2, "1.0", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_2_5(3, "2.5", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_5_0(4, "5.0", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_10_0(5, "10.0", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    TEMP(16, "temp", true, ChannelType.TEMPERATURE, ChannelUnits.FAHRENHEIT),
    HUMID(17, "humid", true, ChannelType.RELATIVE_HUMIDITY, ChannelUnits.PERCENTAGE);

    private final int index;
    private final String name;
    private final boolean analog;
    private final ChannelType type;
    private final ChannelUnits units;

    private DataChannel(int index, String name, boolean analog, ChannelType type, ChannelUnits units) {
        this.index = index;
        this.name = name;
        this.analog = analog;
        this.type = type;
        this.units = units;
    }

    public int getIndex() {
        return this.index;
    }

    public ChannelType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnalog() {
        return this.analog;
    }

    ChannelUnits getUnits() {
        return this.units;
    }
}

