/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class CommandSetBuilder {
    private final InputConversionEngine engine = new InputConversionEngine();

    public CommandSet buildCommandSet(Object object) {
        Class<?> targetClass = object.getClass();
        CommandDictionaryBuilder dictionary = new CommandDictionaryBuilder(targetClass);
        CommandSetImplementation commandSet = new CommandSetImplementation(dictionary, object);
        return commandSet;
    }

    private class CommandSetImplementation
    implements CommandSet {
        private final CommandDictionaryBuilder dict;
        private final Object target;

        private CommandSetImplementation(CommandDictionaryBuilder dict, Object target) {
            this.dict = dict;
            this.target = target;
        }

        @Override
        public Dictionary getCommandDictionary() {
            return this.dict.getCommandDictionary();
        }

        @Override
        public Object invoke(BasicCommand command) throws CommandInvocationException, CommandArgumentMatchException {
            Method method = this.dict.getMethod(command);
            if (method == null) {
                throw new CommandInvocationException("Error: No handler found for command %s with %d arguments", command.getCommand(), command.getArgumentCount());
            }
            return this.invoke(this.target, method, command);
        }

        private Object invoke(Object target, Method method, BasicCommand command) throws CommandInvocationException {
            try {
                RawCommand raw = RawCommand.toRawCommand(command, method, CommandSetBuilder.this.engine);
                return method.invoke(target, raw.getArguments());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new CommandInvocationException("Error: Can't invoke command", ex);
            }
            catch (InvocationTargetException ex) {
                throw new CommandInvocationException(ex);
            }
        }
    }
}

