package org.lsst.ccs.drivers.keithley;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.text.NumberFormatter;

import javax.swing.JFileChooser;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;

/**
 *  Program to control the Keithley N6487 device driver
 *     using a GUI interface
 *
 *  @author Homer Neal
 */
public class N6487Gui extends TestN6487 {

    private static final String VST = "ccs-vst";
    private static final String VST_POWER = "ccs-vstpower";
    private static final long serialVersionUID = -8352262068369045572L;
    private static final Map<Integer, String> pStateMap = new HashMap<>();
/*
    static {
        pStateMap.put(PowerState.PWR_STATE_OFFLINE, "N/A");
        pStateMap.put(PowerState.PWR_STATE_OFF, "Off");
        pStateMap.put(PowerState.PWR_STATE_ON, "On");
    }
    */
    private static final String NB_SPACE = "\u00a0";
    
    private static final JLabel lbCfg = new JLabel("Configuration");
    private static final JLabel lbCfgType = new JLabel("Connection Type");
    private static final JLabel lbCfgPort = new JLabel("Port or Serial#");    
    private static final JLabel lbCfgRate = new JLabel("Baud Rate");
    private static final JButton btCfgCnx = new JButton("Open Connection");
    
    private static final JLabel lbCur = new JLabel("Current Measurement");
    private static final JButton btCurRead = new JButton("Read");
    private static final JButton btCurCali = new JButton("Calibrate");
    private static final JButton btCurRange = new JButton("Set Range");
    private static final JButton btCurRst = new JButton("Reset");

    private static final JLabel lbVolt = new JLabel("Voltage Control");
    private static final JLabel lbCfgVoltage = new JLabel("Set Voltage");
    private static final JLabel lbCfgVoltageRange = new JLabel("Set Voltage Range");
    private static final JLabel lbCfgVoltageState = new JLabel("Voltage State");
    private static final JButton btVoltRead = new JButton("Read");
    private static final JButton btVoltSet = new JButton("Set");
    private static final JButton btVoltOut = new JButton("ON/OFF");
    private static final JButton btVoltRange = new JButton("Set Range");
    private static final JButton btVoltRst = new JButton("Reset");

    private JLabel[] lbPwrName = new JLabel[0];
    private JLabel[] lbPwrState;
    private JLabel[] lbPwrVoltage;
    private JLabel[] lbPwrCurrent;

    private JLabel lbMessage = new JLabel(NB_SPACE);
//    private SynchronousCommandAgent ca;
    private JPanel panel = new JPanel();
    private JPanel cfgPanel = new JPanel();
    private JPanel curPanel = new JPanel();
    private JPanel voltPanel = new JPanel();

    private N6487 n64 = new N6487();
    private int chanNum = 1;

    private String connType;
    private String connPort;
    private Integer connRate;
    private NumberFormatter fmt3 = new NumberFormatter(new DecimalFormat("##0"));
//    private JFormattedTextField tfS = new JFormattedTextField(fmt3);
    private JFormattedTextField tfS = new JFormattedTextField();
    private JFormattedTextField tfP = new JFormattedTextField();
    private JFormattedTextField tfR = new JFormattedTextField(fmt3);

    private Double setVolt;
    private Double setVoltRange;
    private JFormattedTextField tfV = new JFormattedTextField();
    private JFormattedTextField tfVR = new JFormattedTextField();
    private JFormattedTextField tfVO = new JFormattedTextField();

    
    public enum onOff {
        OFF, ON;
    }


    public void initGui() {
//        setName(Names.almostUniqueAgentName("N6487Gui"));
//        setStatusBroadcastPeriod(0);
//        setListenToStatus(true);
//        ca = new SynchronousCommandAgent(fac);
        initComponents();
//        start();
    }

    private void display(String message) {
        lbMessage.setText(message);
    }

    private void SetConnType() {
            connType = (String) tfS.getValue();
            display("Connection type set to " + connType);
    }

    private void SetConnPort() {
            connType = (String) tfP.getValue();
            display("Connection port set to " + connType);
    }

    private void SetConnRate() {
            connRate = (Integer) tfR.getValue();
            display("Connection rate set to " + connType);
    }
    private void SetVoltage() {
            setVolt = (Double) tfV.getValue();
            display("Voltage set to " + setVolt);
            if (setVolt < -75.0) setVolt = -75.0; // some protection please
            if (setVolt > 75.0) setVolt = 75.0;
            display("Voltage set to " + setVolt);
            try {
                n64.setVoltage(setVolt);
                if (n64.getOutput()) {  
                    tfVO.setValue("ON:V="+tfV.getValue());
                } else {
                    tfVO.setValue("OFF:V="+tfV.getValue());
                }
            }
            catch (DriverException f) {
                display("exception incurred on voltage status read");
            }
    }
    private void SetVoltageRange() {
            setVoltRange = (Double) tfVR.getValue();
            display("Connection voltage set to " + setVoltRange);
//                   n64.setVoltageRange(volts);
    }
    private void ShowVoltageState() {
            try {
                
                setVolt = (Double) tfV.getValue();
                if (n64.getOutput()) {  
                    tfVO.setValue("ON:V="+tfV.getValue());
                } else {
                    tfVO.setValue("OFF:V="+tfV.getValue());
                }
            }
            catch (DriverException f) {
                display("exception incurred on voltage status read");
            }

            display("Voltage set to " + setVolt);
//                   n64.setVoltage(volts);
    }

    private void initComponents() {

        /*
        **  Configuration sub-panel
        */
        cfgPanel.setBorder(BorderFactory.createTitledBorder(""));
        cfgPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcC = new GridBagConstraints();
        gbcC.insets = new Insets(4, 4, 4, 4);
        gbcC.anchor = GridBagConstraints.NORTH;
        gbcC.gridx = 0;
        gbcC.gridy = 0;

        cfgPanel.add(lbCfg, gbcC);
        gbcC.gridy++;
        cfgPanel.add(lbCfgType, gbcC);

        gbcC.gridy++;
        Dimension d = tfS.getPreferredSize();
        d.width = 60;

        tfS.setPreferredSize(d);
//            this.setLayout(new GridBagLayout());
//            GridBagConstraints gbc = new GridBagConstraints();
        tfS.setValue("FTDI");
        cfgPanel.add(tfS, gbcC);
//        cfgPanel.add(btCfgTTY, gbcC);
        tfS.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                SetConnType();
//                cfgTTY();
            }
        });
        /* ******* set port ******* */
        gbcC.gridy++;
        cfgPanel.add(lbCfgPort, gbcC);

        gbcC.gridy++;
        d = tfP.getPreferredSize();
        d.width = 60;

        tfP.setPreferredSize(d);
//            this.setLayout(new GridBagLayout());
//            GridBagConstraints gbc = new GridBagConstraints();
        tfP.setValue("A603EPZY");
        cfgPanel.add(tfP, gbcC);
//        cfgPanel.add(btCfgTTY, gbcC);
        tfP.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                SetConnPort();
//                cfgTTY();
            }
        });
        
        /* ******* set rate ******* */
        gbcC.gridy++;
        cfgPanel.add(lbCfgRate, gbcC);

        gbcC.gridy++;
        d = tfR.getPreferredSize();
        d.width = 60;

        tfR.setPreferredSize(d);
//            this.setLayout(new GridBagLayout());
//            GridBagConstraints gbc = new GridBagConstraints();
        tfR.setValue(19200);
        cfgPanel.add(tfR, gbcC);
//        cfgPanel.add(btCfgTTY, gbcC);
        tfR.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                SetConnPort();
//                cfgTTY();
            }
        });
        
        
        
        gbcC.gridy++;
        cfgPanel.add(btCfgCnx, gbcC);
        btCfgCnx.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                cfgCnx();
                        try {
//            n64.open();
            n64.openftdi((String)tfP.getValue(),(Integer)tfR.getValue());
                      }
            catch (DriverException f) {
                display("exception incurred on open attempt");
            }
            }
        });

         /*
        **  Measurement sub-panel
        */
        curPanel.setBorder(BorderFactory.createTitledBorder(""));
        curPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcS = new GridBagConstraints();
        gbcS.insets = new Insets(4, 4, 4, 4);
        gbcS.anchor = GridBagConstraints.NORTH;
        gbcS.gridx = 0;
        gbcS.gridy = 0;

        curPanel.add(lbCur, gbcS);

        gbcS.gridy++;
        curPanel.add(btCurRead, gbcS);
        btCurRead.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                curRead();
                double current = 0.0;
                try {
                    current = n64.readCurrent();
                } catch(DriverException f) {
                    display("DriverException!");
                }
                display("Current = " + current);
            }
        });

        gbcS.gridy++;
        curPanel.add(btCurCali, gbcS);
        btCurCali.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                curCali();
                try {
                   n64.zeroCorrectCurrent();
                } catch(DriverException f) {
                    display("DriverException!");
                }
            }
        });

        gbcS.gridy++;
        curPanel.add(btCurRange, gbcS);
        btCurRange.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                curRange();
                double currange = 0.0002;
                try {
                n64.setCurrentRange(currange);
                } catch(DriverException f) {
                    display("DriverException!");
                }
            }
        });

        gbcS.gridy++;
        curPanel.add(btCurRst, gbcS);
        btCurRst.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                curRst();
                try {
                n64.reset();
                } catch (DriverException f) {
                    display("DriverException!");
                }
            }
        });

/* ----- voltage section ------*/
        voltPanel.setBorder(BorderFactory.createTitledBorder(""));
        voltPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcV = new GridBagConstraints();
        gbcV.insets = new Insets(4, 4, 4, 4);
        gbcV.anchor = GridBagConstraints.NORTH;
        gbcV.gridx = 0;
        gbcV.gridy = 0;

        voltPanel.add(lbVolt, gbcV);

        gbcV.gridy++;
        voltPanel.add(btVoltRead, gbcV);
        btVoltRead.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                voltRead();
                double voltage = 0.0;
                try {
                    voltage = n64.readVoltage();
                } catch(DriverException f) {
                    display("DriverException!");
                }
                display("Voltage = " + voltage);
            }
        });

/*
        gbcV.gridy++;
        voltPanel.add(btVoltSet, gbcV);
        btVoltSet.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                voltCali();
                double volts = 0.10;
                try {
                   n64.setVoltage(volts);
                } catch(DriverException f) {
                    display("DriverException!");
                }
            }
        });
        */
        
       /* ******* set voltage ******* */
        gbcV.gridy++;
        voltPanel.add(lbCfgVoltage, gbcV);

        gbcV.gridy++;
        d = tfV.getPreferredSize();
        d.width = 60;

        tfV.setPreferredSize(d);
//            this.setLayout(new GridBagLayout());
//            GridBagConstraints gbc = new GridBagConstraints();
        tfV.setValue(0.0);
        voltPanel.add(tfV, gbcV);
//        cfgPanel.add(btCfgTTY, gbcC);
        tfV.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                SetVoltage();
//                cfgTTY();
            }
        });
 
        
        gbcV.gridy++;
        voltPanel.add(btVoltOut, gbcV);
        btVoltOut.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                   onOff state = onOff.ON;
                   if (n64.getOutput()) {  
                       n64.setOutput(state == onOff.OFF);

                       ShowVoltageState();
                       
                       display("Voltage OFF");
                   } else {
                       n64.setOutput(state == onOff.ON);
                       double voltage = 0.0;
                       try {
                           voltage = n64.readVoltage();
                       } catch(DriverException f) {
                           display("DriverException!");
                       }

                       ShowVoltageState();
                       
                       display("Voltage output ON and V = " + voltage + " V");

                   }
                } catch(DriverException f) {
                    display("DriverException!");
                }
            }
        });

               /* ******* show voltage output state******* */
        gbcV.gridy++;
        voltPanel.add(lbCfgVoltageState, gbcV);

        gbcV.gridy++;
        d = tfVO.getPreferredSize();
        d.width = 60;

        tfVO.setPreferredSize(d);
//            this.setLayout(new GridBagLayout());
//            GridBagConstraints gbc = new GridBagConstraints();
        tfVO.setValue("UNKNOWN");
        voltPanel.add(tfVO, gbcV);

        /* set voltage range */
/*
        gbcV.gridy++;
        voltPanel.add(btVoltRange, gbcV);
        btVoltRange.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                voltRange();
                double voltrange = 0.0002;
                try {
                n64.setVoltageRange(voltrange);
                } catch(DriverException f) {
                    display("DriverException!");
                }
            }
        });
        */
                
       /* ******* set voltage range ******* */
        gbcV.gridy++;
        voltPanel.add(lbCfgVoltageRange, gbcV);

        gbcV.gridy++;
        d = tfVR.getPreferredSize();
        d.width = 60;

        tfVR.setPreferredSize(d);
//            this.setLayout(new GridBagLayout());
//            GridBagConstraints gbc = new GridBagConstraints();
        tfVR.setValue(0.0002);
        voltPanel.add(tfVR, gbcV);
//        cfgPanel.add(btCfgTTY, gbcC);
        tfVR.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                SetVoltageRange();
//                cfgTTY();
            }
        });
 

        gbcV.gridy++;
        voltPanel.add(btVoltRst, gbcV);
        btCurRst.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                voltRst();
                try {
                n64.reset();
                } catch (DriverException f) {
                    display("DriverException!");
                }
            }
        });

        
        /*
        **  Main panel
        */
        panel.setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridx = 0;
        gbc.gridy = 0;

        panel.add(cfgPanel, gbc);
        gbc.gridx++;
        panel.add(curPanel, gbc);
        gbc.gridx++;
        panel.add(voltPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.NORTH;
        panel.add(lbMessage, gbc);
    }

    public JPanel getPanel() {
        return panel;
    }

   /**
    *  Constructor
    */
    public N6487Gui()
    {
        super();
        initGui();
        
        JPanel xpane = new JPanel();
        xpane.setLayout(new BorderLayout());
        xpane.add(getPanel(), BorderLayout.CENTER);

        final JFrame f = new JFrame("Keithley Control");
        f.setContentPane(xpane);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        f.pack();
        f.setVisible(true);

    }


}
