/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.lsst.ccs.bootstrap.Bootstrap;

class BoostrapAlternativeMain {
    private static List<String> availableClassesList = new ArrayList<String>();
    private static String helpName;
    private static Options cmdOptions;

    BoostrapAlternativeMain() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        cmdOptions = new Options();
        cmdOptions.addOption("h", "help", false, "Print the help message");
        cmdOptions.addOption("mc", "mainClass", true, "The fully qualified name of the MAIN_CLASS to be invoked.");
        cmdOptions.getOption("mainClass").setArgName("MAIN_CLASS");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(cmdOptions, args, true);
        Properties applicationProperties = Bootstrap.getBootstrapApplicationProperties();
        helpName = applicationProperties.getProperty("org.lsst.ccs.bootstrap.altmain.program.name", "CCSBootstrapAlternativeMain");
        String availableClasses = applicationProperties.getProperty("org.lsst.ccs.bootstrap.altmain.classes");
        if (availableClasses != null) {
            StringTokenizer st = new StringTokenizer(availableClasses, ",");
            while (st.hasMoreTokens()) {
                availableClassesList.add(st.nextToken().trim());
            }
        }
        if (line.hasOption("help")) {
            BoostrapAlternativeMain.printHelp();
            return;
        }
        String mainClass = line.getOptionValue("mainClass");
        try {
            int index = Integer.parseInt(mainClass);
            mainClass = availableClassesList.get(index);
        }
        catch (Exception e) {
            for (String availableClass : availableClassesList) {
                if (availableClass.equals(mainClass)) break;
                String className = availableClass.substring(availableClass.lastIndexOf(".") + 1);
                if (!className.equals(mainClass)) continue;
                mainClass = availableClass;
                break;
            }
        }
        if (mainClass == null) {
            BoostrapAlternativeMain.printHelp();
            return;
        }
        try {
            Class<?> main = Class.forName(mainClass);
            Method mainMethod = main.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void printHelp() {
        String footer = "";
        if (availableClassesList.size() > 0) {
            String description = "The MAIN_CLASS to be launched from the list below.\n";
            footer = "\n\tThe MAIN_CLASS can either be the fully qualified name, the index or the class name.\n\n\tAvailable classes: \n";
            int count = 0;
            StringBuilder b = new StringBuilder();
            for (String availableClass : availableClassesList) {
                b.append("\t-" + count + "-  " + availableClass + "\n");
                ++count;
            }
            footer = footer + b.toString();
            Option opt = cmdOptions.getOption("mainClass");
            opt.setDescription(description);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(helpName, "", cmdOptions, footer, true);
    }
}

