/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.jars;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CommonResources {
    public static final URL[] URL_ARRAY_MODEL = new URL[0];
    public static final Logger CURLOG = Logger.getLogger("org.lsst.ccs.utilities");

    public static URL[] getURLsFrom(ClassLoader loader, String commonResourceName) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> enumURL = loader.getResources(commonResourceName);
            while (enumURL.hasMoreElements()) {
                list.add(enumURL.nextElement());
            }
        }
        catch (IOException e) {
            CURLOG.warn("common resource Name error: " + commonResourceName, e);
        }
        return list.toArray(URL_ARRAY_MODEL);
    }

    public static URL[] getURLsFrom(String commonResourceName) {
        return CommonResources.getURLsFrom(Thread.currentThread().getContextClassLoader(), commonResourceName);
    }

    public static URL[] getURLsFor(Object obj, String commonResourceName) {
        String[] urlNames;
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        ArrayList<URL> list = new ArrayList<URL>();
        ClassLoader loader = clazz.getClassLoader();
        URL[] allResources = CommonResources.getURLsFrom(loader, commonResourceName);
        for (String urlName : urlNames = CommonResources.getClassURLNamesFor(clazz)) {
            for (URL urlResource : allResources) {
                if (!urlResource.toString().startsWith(urlName)) continue;
                list.add(urlResource);
            }
        }
        return list.toArray(URL_ARRAY_MODEL);
    }

    public static String[] getClassURLNamesFor(Object obj) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        String classNamePath = clazz.getCanonicalName().replace('.', '/') + ".class";
        ClassLoader loader = clazz.getClassLoader();
        URL[] classRepositories = CommonResources.getURLsFrom(loader, classNamePath);
        String[] res = new String[classRepositories.length];
        for (int ix = 0; ix < classRepositories.length; ++ix) {
            String urlName = classRepositories[ix].toString().replace(classNamePath, "");
            res[ix] = urlName.substring(0, urlName.length() - 1);
        }
        return res;
    }

    public static Properties getPropertiesFrom(URL url) {
        Properties props = new Properties();
        try {
            InputStream is = url.openStream();
            props.load(is);
        }
        catch (Exception e) {
            CURLOG.warn("URL stream error for: " + url, e);
        }
        return props;
    }

    public static String getResourceContainer(URL url, String commonResourceName) {
        int lastSlash;
        String path = url.getPath();
        int idx = path.lastIndexOf(commonResourceName);
        if (idx < 0) {
            return null;
        }
        String pathWithoutResource = path.substring(0, idx - 1);
        String res = pathWithoutResource.substring((lastSlash = pathWithoutResource.lastIndexOf(47)) + 1);
        res = res.endsWith("!") ? res.substring(0, res.length() - 1) : pathWithoutResource;
        return res;
    }

    public static Manifest getManifestFor(Object obj) {
        URL[] jarURLs = CommonResources.getURLsFor(obj, "META-INF/MANIFEST.MF");
        if (jarURLs.length > 0) {
            URL jarURL = jarURLs[0];
            try {
                InputStream is = jarURL.openStream();
                Manifest res = new Manifest(is);
                return res;
            }
            catch (IOException e) {
                CURLOG.warn("Manifest opening problem at " + jarURL, e);
                return null;
            }
        }
        return null;
    }

    public static InputStream getInput(Class clazz, String pathName) throws IOException {
        File file;
        if (pathName.endsWith("properties")) {
            return BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)pathName, (Class)clazz);
        }
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)pathName, (Class)clazz);
        if (is == null && (file = new File(pathName)).exists()) {
            is = new FileInputStream(file);
        }
        if (is == null) {
            throw new IOException(pathName + "no input found!");
        }
        return is;
    }

    public static Properties getPropertiesFromAny(String name) {
        return BootstrapResourceUtils.getBootstrapProperties((String)name);
    }

    public static Properties gatherAllPropertiesFrom(ClassLoader loader, String loaderResourceName) {
        Properties res = new Properties();
        URL[] urls = CommonResources.getURLsFrom(loader, loaderResourceName);
        for (int ix = urls.length - 1; ix >= 0; --ix) {
            URL url = urls[ix];
            try {
                InputStream is = url.openStream();
                res.load(is);
                is.close();
                continue;
            }
            catch (IOException e) {
                CURLOG.log(Level.WARNING, "reading for properties url : " + url, e);
            }
        }
        File file = new File(loaderResourceName);
        if (file.exists()) {
            try (FileInputStream is = new FileInputStream(file);){
                res.load(is);
            }
            catch (IOException e) {
                CURLOG.log(Level.WARNING, "", e);
            }
        }
        return res;
    }

    public static Properties gatherAllPropertiesFrom(String loaderResourceName) {
        return CommonResources.gatherAllPropertiesFrom(Thread.currentThread().getContextClassLoader(), loaderResourceName);
    }
}

