package org.lsst.ccs.drivers.ftdi;

/**
 ***************************************************************************
 **
 **  Interface for the FTDI access routines
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public interface FtdiInterface {

    public void open(int index, String serial) throws FtdiException;

    public void open(String node, int index, String serial)
        throws FtdiException;

    public void close() throws FtdiException;

    public void setBaudrate(int baudrate) throws FtdiException;

    public void setDataCharacteristics(int wordLength, int stopBits, int parity)
        throws FtdiException;

    public void setTimeouts(int rcveTimeout, int xmitTimeout)
        throws FtdiException;

    public int read(byte[] data) throws FtdiException;

    public int read(byte[] data, int offset, int count) throws FtdiException;

    public int write(byte[] data) throws FtdiException;

    public int write(byte[] data, int offset, int count) throws FtdiException;

    public int getQueueStatus() throws FtdiException;

    public int getModemStatus() throws FtdiException;

}
