/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.ftdi.FtdiInterface;

public class FtdiLocal
implements FtdiInterface {
    private long handle;

    static {
        System.loadLibrary("Ftdi");
    }

    @Override
    public void open(int index, String serial) throws FtdiException {
        this.handle = this.openJNI(index, serial);
    }

    @Override
    public void open(String node, int index, String serial) throws FtdiException {
        throw new FtdiException("Invalid remote open call");
    }

    @Override
    public void close() throws FtdiException {
        this.closeJNI(this.handle);
        this.handle = 0L;
    }

    @Override
    public void setBaudrate(int baudrate) throws FtdiException {
        this.setBaudrateJNI(this.handle, baudrate);
    }

    @Override
    public void setDataCharacteristics(int wordLength, int stopBits, int parity) throws FtdiException {
        this.setDataCharacteristicsJNI(this.handle, wordLength, stopBits, parity);
    }

    @Override
    public void setTimeouts(int rcveTimeout, int xmitTimeout) throws FtdiException {
        this.setTimeoutsJNI(this.handle, rcveTimeout, xmitTimeout);
    }

    @Override
    public int read(byte[] data) throws FtdiException {
        return this.readJNI(this.handle, data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int count) throws FtdiException {
        return this.readJNI(this.handle, data, offset, count);
    }

    @Override
    public int write(byte[] data) throws FtdiException {
        return this.writeJNI(this.handle, data, 0, data.length);
    }

    @Override
    public int write(byte[] data, int offset, int count) throws FtdiException {
        return this.writeJNI(this.handle, data, offset, count);
    }

    @Override
    public int getQueueStatus() throws FtdiException {
        return this.getQueueStatusJNI(this.handle);
    }

    @Override
    public int getModemStatus() throws FtdiException {
        return this.getModemStatusJNI(this.handle);
    }

    private native long openJNI(int var1, String var2) throws FtdiException;

    private native void closeJNI(long var1) throws FtdiException;

    private native void setBaudrateJNI(long var1, int var3) throws FtdiException;

    private native void setDataCharacteristicsJNI(long var1, int var3, int var4, int var5) throws FtdiException;

    private native void setTimeoutsJNI(long var1, int var3, int var4) throws FtdiException;

    private native int readJNI(long var1, byte[] var3, int var4, int var5) throws FtdiException;

    private native int writeJNI(long var1, byte[] var3, int var4, int var5) throws FtdiException;

    private native int getQueueStatusJNI(long var1) throws FtdiException;

    private native int getModemStatusJNI(long var1) throws FtdiException;
}

