/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Playlist;
import org.lsst.ccs.daq.ims.RegisterClient;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.Utils;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.daq.ims.channel.FitsIntReader;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.daq.ims.example.FitsFile;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.direct.DirectByteBufferCache;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class CommandTool {
    private static final FitsHeadersSpecificationsBuilder HEADER_SPEC_BUILDER = new FitsHeadersSpecificationsBuilder();
    private static final Logger LOG;
    private Store store;
    private FocalPlane focalPlane = FocalPlane.createFocalPlane();
    private ImageListener imageListener;
    private static final DirectByteBufferCache byteBufferCache;

    @Command(name="connect", description="Connect to a DAQ store")
    public void connect(@Argument(name="partition", description="Partition name") String partition, @Argument(name="geometry", description="Override default geometry", defaultValue="") String geometry) throws DAQException {
        if (this.store != null) {
            this.store.close();
        }
        this.store = new Store(partition);
        this.focalPlane = !geometry.isEmpty() ? FocalPlane.createFocalPlane((String)geometry) : (partition.equals("ats") || partition.equals("lat") ? FocalPlane.createFocalPlane((String)"AUXTEL") : FocalPlane.createFocalPlane());
    }

    @Command(name="close", description="Close DAQ store")
    public void close() throws DAQException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Command(name="list", alias="ls", description="List folders/files")
    public void list(@Argument(name="folder", description="Path", defaultValue="") String path) throws DAQException {
        this.checkStore();
        Utils.list(this.store, path).forEach(System.out::println);
    }

    @Command(name="mkdir", description="Create new folder")
    public void mkdir(String folderName) throws DAQException {
        this.checkStore();
        this.store.getCatalog().insert(folderName);
    }

    @Command(name="rmdir", description="Delete folder")
    public void rmdir(String folderName) throws DAQException {
        this.checkStore();
        this.store.getCatalog().remove(folderName);
    }

    @Command(name="rm", description="Delete image")
    public void rm(String path) throws DAQException {
        this.checkStore();
        Image image = Utils.imageFromPath(this.store, path);
        image.delete();
    }

    @Command(name="mv", description="Move image")
    public void mv(String path, String targetFolderName) throws DAQException {
        this.checkStore();
        Image image = Utils.imageFromPath(this.store, path);
        Folder target = this.store.getCatalog().find(targetFolderName);
        if (target == null) {
            throw new RuntimeException("No such folder: " + target);
        }
        image.moveTo(targetFolderName);
    }

    @Command(name="showPlaylist", alias="sp", description="List contents of playlist")
    public void pl(String playlistFile) throws DAQException, IOException {
        File file = new File(playlistFile);
        this.checkStore();
        Emulator emulator = this.store.getEmulator();
        try (Playlist playlist = emulator.openPlaylist(file);){
            List<Image> images = playlist.getImages();
            images.stream().map(image -> String.format("%s %s %s %s", image.getMetaData().getName(), Utils.imageSize(image), image.getMetaData().getTimestamp(), image.getMetaData().getAnnotation())).forEach(System.out::println);
        }
    }

    @Command(name="addPlaylistImage", alias="ap", description="Add an image to a playlist")
    public void pla(String playlistFile, String imagePath) throws DAQException, IOException {
        this.checkStore();
        Image image = Utils.imageFromPath(this.store, imagePath);
        Emulator emulator = this.store.getEmulator();
        File file = new File(playlistFile);
        try (Playlist playlist = emulator.openPlaylist(file);){
            playlist.add(image);
        }
    }

    @Command(name="emulators", description="List configured emulators")
    public LocationSet emulators() throws DAQException {
        this.checkStore();
        Emulator emulator = this.store.getEmulator();
        return emulator.getLocations();
    }

    @Command(name="play", description="Start a playlist")
    public void play(String playlistFile, @Argument(name="repeat", description="Repeat", defaultValue="false") boolean repeat) throws DAQException, IOException {
        this.checkStore();
        File file = new File(playlistFile);
        Emulator emulator = this.store.getEmulator();
        try (Playlist playlist = emulator.openPlaylist(file);){
            playlist.start(repeat);
        }
    }

    @Command(name="halt", description="Halt a playlist")
    public void halt() throws DAQException {
        this.checkStore();
        Emulator emulator = this.store.getEmulator();
        emulator.halt();
    }

    @Command(name="stop", description="Stop a playlist")
    public void stop() throws DAQException {
        this.checkStore();
        Emulator emulator = this.store.getEmulator();
        emulator.stop();
    }

    @Command(name="restart", description="Restart a playlist")
    public void restart() throws DAQException {
        this.checkStore();
        Emulator emulator = this.store.getEmulator();
        emulator.restart();
    }

    @Command(name="locations", description="List configured locations")
    public LocationSet locations() throws DAQException {
        this.checkStore();
        return this.store.getConfiguredSources();
    }

    @Command(name="platform", description="Get platform name")
    public String platform() throws DAQException {
        this.checkStore();
        return this.store.getClientPlatform();
    }

    @Command(name="version", description="Get version info")
    public Version version() throws DAQException {
        return Store.getClientVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="checkRaw")
    public void checkRaw(String path, @Argument(defaultValue="1950720") int bufferSize, @Argument(defaultValue="4") int nThreads) throws DAQException, IOException, FitsException, InterruptedException, ExecutionException {
        this.checkStore();
        Image image = Utils.imageFromPath(this.store, path);
        List<Source> sources = image.listSources();
        long totalSize = 0L;
        for (Source source : sources) {
            totalSize += source.size();
        }
        System.out.printf("Expected size %,d bytes\n", totalSize);
        ThreadFactory readThreadFactory = r -> new ReadThread(r, bufferSize, image.getStore().getPartition());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), readThreadFactory);
        try {
            executor.prestartAllCoreThreads();
            ArrayList<Future<Object[]>> futures = new ArrayList<Future<Object[]>>();
            long start = System.nanoTime();
            for (Source source : sources) {
                Callable<Object[]> callable = () -> {
                    CRC32 cksum = new CRC32();
                    ReadThread thread = (ReadThread)Thread.currentThread();
                    ByteBuffer buffer = thread.buffer;
                    try (ByteChannel channel = source.openChannel(thread.store, Source.ChannelMode.READ);){
                        int l;
                        long readSize = 0L;
                        while ((l = channel.read(buffer)) >= 0) {
                            readSize += (long)l;
                            buffer.flip();
                            cksum.update(buffer);
                            buffer.clear();
                        }
                        Object[] objectArray = new Object[]{source, readSize, cksum.getValue()};
                        return objectArray;
                    }
                };
                futures.add(executor.submit(callable));
            }
            HashMap<Source, Long> checksums = new HashMap<Source, Long>();
            long totalReadSize = 0L;
            for (Future future : futures) {
                Object[] result = (Object[])future.get();
                totalReadSize += ((Long)result[1]).longValue();
                Source source = (Source)result[0];
                checksums.put(source, (Long)result[2]);
            }
            long stop = System.nanoTime();
            System.out.printf("Read %,d bytes in %,dns (%d MBytes/second)\n", totalReadSize, stop - start, 1000L * totalReadSize / (stop - start));
            ArrayList sourceList = new ArrayList(checksums.keySet());
            Collections.sort(sourceList);
            for (Source source : sourceList) {
                System.err.printf("Source %s crc32 %d\n", source.getLocation(), checksums.get(source));
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="readRaw")
    public void readRaw(String path, @Argument(defaultValue=".", description="Folder where .raw (and .meta) files will be written") File dir, @Argument(defaultValue="1950720") int bufferSize, @Argument(defaultValue="4") int nThreads) throws DAQException, IOException, FitsException, InterruptedException, ExecutionException {
        this.checkStore();
        Image image = Utils.imageFromPath(this.store, path);
        List<Source> sources = image.listSources();
        long totalSize = 0L;
        for (Source source : sources) {
            totalSize += source.size();
        }
        System.out.printf("Expected size %,d bytes\n", totalSize);
        ThreadFactory readThreadFactory = r -> new ReadThread(r, bufferSize, image.getStore().getPartition());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), readThreadFactory);
        try {
            executor.prestartAllCoreThreads();
            ArrayList futures = new ArrayList();
            long start = System.nanoTime();
            for (Source source : sources) {
                Callable<Long> callable = () -> {
                    File metaFile = new File(dir, String.format("%s_%s.meta", source.getImage().getMetaData().getName(), source.getLocation().toString().replace("/", "_")));
                    try (PrintWriter metaWriter = new PrintWriter(metaFile);){
                        metaWriter.println(Arrays.toString(source.getMetaData().getRegisterValues()));
                    }
                    File file = new File(dir, String.format("%s_%s.raw", source.getImage().getMetaData().getName(), source.getLocation().toString().replace("/", "_")));
                    ReadThread thread = (ReadThread)Thread.currentThread();
                    ByteBuffer buffer = thread.buffer;
                    try (ByteChannel channel = source.openChannel(thread.store, Source.ChannelMode.READ);){
                        Long l;
                        block19: {
                            FileChannel out = new FileOutputStream(file).getChannel();
                            try {
                                int l2;
                                long readSize = 0L;
                                while ((l2 = channel.read(buffer)) >= 0) {
                                    readSize += (long)l2;
                                    buffer.flip();
                                    out.write(buffer);
                                    buffer.clear();
                                }
                                l = readSize;
                                if (out == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            out.close();
                        }
                        return l;
                    }
                };
                futures.add(executor.submit(callable));
            }
            long totalReadSize = 0L;
            for (Future future : futures) {
                totalReadSize += ((Long)future.get()).longValue();
            }
            long stop = System.nanoTime();
            System.out.printf("Read %,d bytes in %,dns (%d MBytes/second)\n", totalReadSize, stop - start, 1000L * totalReadSize / (stop - start));
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="writeRaw", description="Write a set of .raw images into the 2 day store")
    public void writeRaw(File dir, @Argument(defaultValue="emu") String targetFolderName, @Argument(defaultValue="(\\w+)_(R\\d\\d)_(Reb[0-2|W|G]).raw") String pattern) throws DAQException, IOException {
        this.checkStore();
        Folder target = this.store.getCatalog().find(targetFolderName);
        if (target == null) {
            throw new RuntimeException("No such folder: " + targetFolderName);
        }
        final Path dirPath = dir.toPath();
        final Pattern compiled = Pattern.compile(pattern);
        final TreeMap obsIds = new TreeMap();
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Matcher matcher = compiled.matcher(dirPath.relativize(file).getFileName().toString());
                if (matcher.matches()) {
                    FitsFile.ObsId id = (FitsFile.ObsId)obsIds.get(matcher.group(1));
                    if (id == null) {
                        id = new FitsFile.ObsId(matcher.group(1));
                        obsIds.put(matcher.group(1), id);
                    }
                    Location location = Location.of((String)(matcher.group(2) + "/" + matcher.group(3)));
                    Path meta = file.resolveSibling(file.getFileName().toString().replace(".raw", ".meta"));
                    if (Files.exists(meta, new LinkOption[0])) {
                        id.add(location, file, meta);
                    } else {
                        id.add(location, file, null);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (FitsFile.ObsId id : obsIds.values()) {
            System.out.println(id.getObsId());
            ImageMetaData meta = new ImageMetaData(id.getObsId(), "raw", "Image Annotation", 0, id.getLocations());
            Image image = target.insert(meta);
            block14: for (FitsFile.Source rsource : id.getSources().values()) {
                FitsFile.RawSource rawSource = (FitsFile.RawSource)rsource;
                System.out.println("\t" + rawSource.getLocation());
                int[] registerValues = rawSource.getMetaData();
                Source source = image.addSource(rawSource.getLocation(), registerValues);
                Path file = rawSource.getRaw();
                FileChannel in = new FileInputStream(file.toFile()).getChannel();
                try {
                    ByteChannel channel = source.openChannel(Source.ChannelMode.WRITE);
                    try {
                        ByteBuffer buffer = byteBufferCache.allocateDirect(1950720);
                        try {
                            while (true) {
                                buffer.clear();
                                int len = in.read(buffer);
                                if (len < 0) continue block14;
                                buffer.flip();
                                channel.write(buffer);
                            }
                        }
                        finally {
                            byteBufferCache.free(buffer);
                        }
                    }
                    finally {
                        if (channel == null) continue;
                        channel.close();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    @Command(name="listen", description="Listen for images")
    public void listen() {
        this.checkStore();
        this.imageListener = new ImageListener(){

            @Override
            public void imageCreated(Image image) {
                System.out.println("Image created " + image.getMetaData().getName());
            }

            @Override
            public void imageComplete(Image image) {
                try {
                    System.out.println("Image complete " + image.getMetaData().getName());
                    List<Source> sources = image.listSources();
                    for (Source source : sources) {
                        SourceMetaData smd = source.getMetaData();
                        System.out.printf("Source location: %s length: %s\n", smd.getLocation(), Utils.humanReadableByteCount(smd.getLength()));
                    }
                }
                catch (DAQException ex) {
                    LOG.log(Level.SEVERE, "Exception in imageComplete listener", ex);
                }
            }
        };
        this.store.addImageListener(this.imageListener);
    }

    @Command(name="unlisten", description="Stop listen for images")
    public void unlisten() {
        this.checkStore();
        this.store.removeImageListener(this.imageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="read", description="Read and decode data in image")
    public void read(String path, @Argument(defaultValue=".", description="Folder where FITS files will be written") File dir, @Argument(defaultValue="1950720") int bufferSize, @Argument(defaultValue="4") int nThreads) throws DAQException, IOException, FitsException, InterruptedException, ExecutionException {
        this.checkStore();
        Image image = Utils.imageFromPath(this.store, path);
        List<Source> sources = image.listSources();
        long totalSize = 0L;
        for (Source source : sources) {
            totalSize += source.size();
        }
        System.out.printf("Expected size %,d bytes\n", totalSize);
        ThreadFactory readThreadFactory = r -> new ReadThread(r, bufferSize, image.getStore().getPartition());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(sources.size(), sources.size(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), readThreadFactory);
        try {
            executor.prestartAllCoreThreads();
            ArrayList futures = new ArrayList();
            long start = System.nanoTime();
            Semaphore semaphore = new Semaphore(nThreads);
            for (Source source : sources) {
                Callable<Long> callable = () -> {
                    ReadThread thread = (ReadThread)Thread.currentThread();
                    Reb reb = this.focalPlane.getReb(source.getLocation().getRaftName() + "/" + source.getLocation().getBoardName());
                    FitsIntWriter.FileNamer namer = props -> new File(dir, String.format("%s_%s_%s.fits", props.get("ImageName"), props.get("RaftBay"), props.get("CCDSlot")));
                    try (ByteChannel channel = source.openChannel(thread.store, Source.ChannelMode.READ);){
                        Long l;
                        try (FitsIntWriter decompress = new FitsIntWriter(source, reb, HEADER_SPEC_BUILDER.getHeaderSpecifications(), namer, null);){
                            long readSize = 0L;
                            ByteBuffer buffer = thread.buffer;
                            while (true) {
                                semaphore.acquire();
                                try {
                                    int l2 = channel.read(buffer);
                                    if (l2 < 0) break;
                                    readSize += (long)l2;
                                }
                                finally {
                                    semaphore.release();
                                }
                                buffer.flip();
                                decompress.write(buffer.asIntBuffer());
                                buffer.clear();
                            }
                            l = readSize;
                        }
                        return l;
                    }
                };
                futures.add(executor.submit(callable));
            }
            long totalReadSize = 0L;
            for (Future future : futures) {
                totalReadSize += ((Long)future.get()).longValue();
            }
            long stop = System.nanoTime();
            System.out.printf("Read %,d bytes in %,dns (%d MBytes/second)\n", totalReadSize, stop - start, 1000L * totalReadSize / (stop - start));
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="write", description="Write a set of FITS files to the store")
    public void write(String targetFolderName, File dir, @Argument(defaultValue="*.fits") String pattern) throws IOException, TruncatedFileException, DAQException {
        this.checkStore();
        Folder target = this.store.getCatalog().find(targetFolderName);
        if (target == null) {
            throw new RuntimeException("No such folder: " + targetFolderName);
        }
        final Path dirPath = dir.toPath();
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        final TreeMap obsIds = new TreeMap();
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (matcher.matches(dirPath.relativize(file))) {
                    try (BufferedFile bf = new BufferedFile(file.toFile(), "r");){
                        Path meta;
                        Header primary = new Header((ArrayDataInput)bf);
                        Header image = new Header((ArrayDataInput)bf);
                        FitsFile ff = new FitsFile(file.toFile(), primary, image);
                        FitsFile.ObsId id = (FitsFile.ObsId)obsIds.get(ff.getObsId());
                        if (id == null) {
                            id = new FitsFile.ObsId(ff.getObsId());
                            obsIds.put(ff.getObsId(), id);
                        }
                        if (Files.exists(meta = file.resolveSibling(file.getFileName().toString().replace(".fits", ".meta")), new LinkOption[0])) {
                            id.add(ff, meta);
                        } else {
                            id.add(ff, null);
                        }
                    }
                    catch (FitsException x) {
                        throw new IOException("Error reading FITS file: " + file, x);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (FitsFile.ObsId id : obsIds.values()) {
            System.out.println(id.getObsId());
            ImageMetaData meta = new ImageMetaData(id.getObsId(), "raw", "Image Annotation", 0, id.getLocations());
            Image image = target.insert(meta);
            block14: for (FitsFile.Source fSource : id.getSources().values()) {
                FitsFile.FitsSource ffSource = (FitsFile.FitsSource)fSource;
                Reb reb = this.focalPlane.getReb(ffSource.getLocation().getRaftName() + "/" + ffSource.getLocation().getBoardName());
                System.out.println("\t" + ffSource.getLocation());
                Location.LocationType locationType = reb.isAuxtelREB() ? Location.LocationType.SCIENCE : reb.getLocation().type();
                Map.Entry<FitsFile, int[]> firstEntry = ffSource.getFiles().firstEntry();
                int[] registerValues = firstEntry.getValue();
                Source source = image.addSource(reb.getLocation(), registerValues);
                File[] files = (File[])ffSource.getFiles().keySet().stream().map(FitsFile::getFile).toArray(File[]::new);
                try (FitsIntReader reader = new FitsIntReader(locationType, reb.isAuxtelREB(), files);){
                    ByteChannel channel = source.openChannel(Source.ChannelMode.WRITE);
                    try {
                        ByteBuffer buffer = byteBufferCache.allocateDirect(1950720);
                        try {
                            buffer.order(ByteOrder.LITTLE_ENDIAN);
                            IntBuffer intBuffer = buffer.asIntBuffer();
                            while (true) {
                                intBuffer.clear();
                                int len = reader.read(intBuffer);
                                if (len < 0) continue block14;
                                buffer.position(0);
                                buffer.limit(4 * len);
                                channel.write(buffer);
                            }
                        }
                        finally {
                            byteBufferCache.free(buffer);
                        }
                    }
                    finally {
                        if (channel == null) continue;
                        channel.close();
                    }
                }
            }
        }
    }

    @Command(name="purge", description="Purge files in a folder older than some delta to make space")
    public void purge(String folderName, String delta) throws DAQException {
        this.checkStore();
        Folder folder = this.store.getCatalog().find(folderName);
        if (folder == null) {
            throw new IllegalArgumentException("Invalid folder: " + folder);
        }
        List<Image> images = folder.listImages();
        images.sort((i1, i2) -> i1.getMetaData().getTimestamp().compareTo(i2.getMetaData().getTimestamp()));
        Instant cutOff = Instant.now().minus(Duration.parse(delta));
        for (Image image : images) {
            if (!image.getMetaData().getTimestamp().isBefore(cutOff)) break;
            System.out.println("Deleting: " + image.getMetaData().getName());
            image.delete();
        }
    }

    @Command(name="readReg", description="Read registers")
    public void readReg(int ... address) throws DAQException {
        this.checkStore();
        RegisterClient registerClient = this.store.getRegisterClient();
        Map<Location, int[]> result = registerClient.readRegisters(this.locations(), address);
        for (Location location : this.locations()) {
            System.out.printf("%s: %s\n", location, Arrays.stream(result.get(location)).mapToObj(i -> String.format("%08x", i)).collect(Collectors.joining(",")));
        }
    }

    private void checkStore() {
        if (this.store == null) {
            throw new RuntimeException("Please connect to store first");
        }
    }

    static {
        HEADER_SPEC_BUILDER.addSpecFile("primary.spec");
        HEADER_SPEC_BUILDER.addSpecFile("daqv4-primary.spec", "primary");
        HEADER_SPEC_BUILDER.addSpecFile("extended.spec");
        LOG = Logger.getLogger(CommandTool.class.getName());
        byteBufferCache = DirectByteBufferCache.instance();
    }

    private static class ReadThread
    extends Thread {
        private final ByteBuffer buffer;
        private final Store store;
        private static int n = 0;

        ReadThread(Runnable r, int bufferSize, String partition) {
            super(r);
            this.setName("DAQ_read_thread_" + n++);
            this.setDaemon(true);
            this.buffer = byteBufferCache.allocateDirect(bufferSize);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            try {
                this.store = new Store(partition);
            }
            catch (DAQException x) {
                throw new RuntimeException("Error creating store for read thread", x);
            }
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                byteBufferCache.free(this.buffer);
                try {
                    this.store.close();
                }
                catch (DAQException x) {
                    throw new RuntimeException("Error closing store", x);
                }
            }
        }
    }
}

