/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.channel.BadPixelDetector;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.NullIntWriter;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORWritableIntChannel;

public class RawDump {
    public static void main(String[] args) throws IOException, DAQException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try (Store store = new Store("camera");){
            Folder raw = store.getCatalog().find("raw");
            List images = raw.listImages();
            Collections.sort(images);
            for (Image image : images) {
                List sources = image.listSources();
                for (Source source : sources) {
                    if (source.getMetaData().getLength() <= 0L) continue;
                    try {
                        ByteChannel openChannel = source.openChannel(Source.ChannelMode.READ);
                        try (NullIntWriter devNull = new NullIntWriter();
                             BadPixelDetector bad = new BadPixelDetector((WritableIntChannel)devNull);
                             XORWritableIntChannel xor = new XORWritableIntChannel((WritableIntChannel)bad, 131071);
                             Decompress18BitChannel decompress18BitChannel = new Decompress18BitChannel((WritableIntChannel)xor);){
                            while (true) {
                                buffer.clear();
                                int read = openChannel.read(buffer);
                                if (read < 0) break;
                                buffer.flip();
                                IntBuffer intBuffer = buffer.asIntBuffer();
                                decompress18BitChannel.write(intBuffer);
                            }
                            System.out.printf("%s %s %d/%d\n", image.getMetaData().getName(), source.getLocation(), bad.getBadPixels(), bad.getTotalPixels());
                        }
                        finally {
                            if (openChannel == null) continue;
                            openChannel.close();
                        }
                    }
                    catch (IOException x) {
                        System.out.printf("%s %s Error\n", image.getMetaData().getName(), source.getLocation());
                    }
                }
            }
        }
    }
}

