/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.zip.CRC32;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.daq.ims.channel.IntFileChannelReader;
import org.lsst.ccs.daq.ims.channel.MemoryMappedIntFileReader;

public class IntFileChannelReaderTest {
    private static File tempFile;
    private static long checkSum;

    @BeforeClass
    public static void setUpClass() throws IOException {
        tempFile = Files.createTempFile("test", "data", new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        ByteBuffer bb = ByteBuffer.allocateDirect(100000);
        IntBuffer ib = bb.asIntBuffer();
        Random random = new Random(12345L);
        while (ib.hasRemaining()) {
            ib.put(random.nextInt(1000000));
        }
        bb.limit(ib.position() * 4);
        try (FileChannel fc = new FileOutputStream(tempFile).getChannel();){
            fc.write(bb);
        }
        bb.rewind();
        CRC32 crc32 = new CRC32();
        crc32.update(bb);
        checkSum = crc32.getValue();
        Assert.assertEquals((long)100000L, (long)tempFile.length());
    }

    @Test
    public void readTest1() throws FileNotFoundException, IOException {
        try (FileChannel fc = new FileInputStream(tempFile).getChannel();){
            ByteBuffer bb = ByteBuffer.allocateDirect(9000);
            IntBuffer ib = bb.asIntBuffer();
            CRC32 crc32 = new CRC32();
            try (MemoryMappedIntFileReader mmifr = new MemoryMappedIntFileReader(fc, 0L, 100000);){
                while (true) {
                    ib.clear();
                    int read = mmifr.read(ib);
                    if (read < 0) {
                        break;
                    }
                    bb.position(0);
                    bb.limit(ib.position() * 4);
                    crc32.update(bb);
                }
            }
            Assert.assertEquals((long)checkSum, (long)crc32.getValue());
        }
    }

    @Test
    public void readTest2() throws FileNotFoundException, IOException {
        try (FileChannel fc = new FileInputStream(tempFile).getChannel();){
            ByteBuffer bb = ByteBuffer.allocateDirect(9000);
            IntBuffer ib = bb.asIntBuffer();
            CRC32 crc32 = new CRC32();
            try (IntFileChannelReader mmifr = new IntFileChannelReader(fc, 0L, 100000);){
                while (true) {
                    ib.clear();
                    int read = mmifr.read(ib);
                    if (read < 0) {
                        break;
                    }
                    bb.position(0);
                    bb.limit(ib.position() * 4);
                    crc32.update(bb);
                }
            }
            Assert.assertEquals((long)checkSum, (long)crc32.getValue());
        }
    }

    @Test
    public void readTest3() throws FileNotFoundException, IOException {
        FileChannel fc = new FileInputStream(tempFile).getChannel();
        try {
            ByteBuffer bb = ByteBuffer.allocateDirect(9000);
            CRC32 crc32 = new CRC32();
            try {
                MemoryMappedIntFileReader mmifr = new MemoryMappedIntFileReader(fc, 0L, 100000);
                try {
                    while (true) {
                        bb.clear();
                        while (bb.hasRemaining()) {
                            int read = mmifr.read();
                            bb.putInt(read);
                        }
                        bb.flip();
                        crc32.update(bb);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        mmifr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (EOFException x) {
                bb.flip();
                crc32.update(bb);
                Assert.assertEquals((long)checkSum, (long)crc32.getValue());
                if (fc != null) {
                    fc.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            }
            throw throwable;
        }
    }

    @Test
    public void readTest4() throws FileNotFoundException, IOException {
        FileChannel fc = new FileInputStream(tempFile).getChannel();
        try {
            ByteBuffer bb = ByteBuffer.allocateDirect(9000);
            CRC32 crc32 = new CRC32();
            try {
                IntFileChannelReader mmifr = new IntFileChannelReader(fc, 0L, 100000);
                try {
                    while (true) {
                        bb.clear();
                        while (bb.hasRemaining()) {
                            int read = mmifr.read();
                            bb.putInt(read);
                        }
                        bb.flip();
                        crc32.update(bb);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        mmifr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (EOFException x) {
                bb.flip();
                crc32.update(bb);
                Assert.assertEquals((long)checkSum, (long)crc32.getValue());
                if (fc != null) {
                    fc.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            }
            throw throwable;
        }
    }
}

