/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.Set;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.channel.FitsIntReader;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.daq.ims.example.FitsFile;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.image.direct.DirectByteBufferCache;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class FitsReadWriteTest {
    public static void main(String[] args) throws IOException, TruncatedFileException, FitsException, DAQException {
        File[] files = new File[]{new File("/home/tonyj/Data/ComCam/tiago/09006001-R22-S10-det093-000.fits"), new File("/home/tonyj/Data/ComCam/tiago/09006001-R22-S11-det094-000.fits"), new File("/home/tonyj/Data/ComCam/tiago/09006001-R22-S12-det095-000.fits")};
        int[] registerValues = new int[]{};
        boolean i = false;
        for (File file : files) {
            try (BufferedFile bf = new BufferedFile(file, "r");){
                Header primary = new Header((ArrayDataInput)bf);
                Header image = new Header((ArrayDataInput)bf);
                FitsFile fitsFile = new FitsFile(file, primary, image);
                registerValues = fitsFile.getReadOutParameters();
            }
        }
        IntBuffer buffer = IntBuffer.allocate(28328940);
        int length = 0;
        try (FitsIntReader reader = new FitsIntReader(Location.LocationType.SCIENCE, false, files);){
            int l;
            while ((l = reader.read(buffer)) > 0) {
                length += l;
            }
        }
        System.out.println(length);
        System.out.println(buffer.position());
        buffer.flip();
        System.out.println(buffer.remaining());
        FitsHeadersSpecificationsBuilder headerSpecBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecBuilder.addSpecFile("primary.spec");
        headerSpecBuilder.addSpecFile("daqv4-primary.spec", "primary");
        headerSpecBuilder.addSpecFile("extended.spec");
        FocalPlane focalPlane = FocalPlane.createFocalPlane();
        Reb reb = focalPlane.getReb("R22/Reb1");
        FitsIntWriter.FileNamer namer = props -> new File(String.format("/home/tonyj/Data/ComCam/tiago/test-%s-%s.fits", props.get("RaftBay"), props.get("CCDSlot")));
        ImageMetaData imd = new ImageMetaData("testName", "folder", "annotation", length, (Set)LocationSet.of((String[])new String[]{"R22/Reb1"}));
        FitsIntWriter.PerCCDMetaDataProvider extra = ccd -> {
            FitsHeaderMetadataProvider provider = new FitsHeaderMetadataProvider(){

                public MetaDataSet getPrimaryHeaderMetadata() {
                    MetaDataSet mds = new MetaDataSet();
                    mds.addMetaData("primary", "Firmware", (Object)"99");
                    mds.addMetaData("primary", "Platform", (Object)"DAQ=99");
                    mds.addMetaData("primary", "CCDControllerSerial", (Object)"123456789");
                    mds.addMetaData("primary", "DAQVersion", (Object)"99.999");
                    return mds;
                }

                public MetaDataSet getDataExtendedHeaderMetadata(String imageExtensionName) {
                    return this.getPrimaryHeaderMetadata();
                }

                public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
                    return null;
                }
            };
            return Collections.singletonList(provider);
        };
        try (FitsIntWriter decompress = new FitsIntWriter(imd, "test", reb, namer);){
            decompress.completeInitialization(Location.LocationType.SCIENCE, Location.of((String)"R22/Reb1"), registerValues, headerSpecBuilder.getHeaderSpecifications(), extra);
            decompress.write(buffer);
        }
        System.out.println(DirectByteBufferCache.instance().toString());
    }

    static {
        FitsFactory.setUseHierarch((boolean)true);
    }
}

