/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.SegmentGeometryConstants;

public class Segment
extends Geometry {
    private final int channel;

    Segment(SegmentGeometryConstants segmentGeometryConstants, int channel) {
        super("Seg", new Dimension(segmentGeometryConstants.getSegmentParallelActiveSize(), segmentGeometryConstants.getSegmentSerialActiveSize()));
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getSegmentSerialActiveSize() {
        return this.getHeight();
    }

    public int getSegmentParallelActiveSize() {
        return this.getWidth();
    }

    protected void addGeometryToGrid(Geometry child, int p, int s) {
        throw new UnsupportedOperationException("Cannot add a geometry to a Segment.");
    }

    static Segment createCCDSegment(CCDType ccdType, int channel, SegmentsRotation rotation) {
        SegmentGeometryConstants geomConstants = ccdType.getCCDGeometryConstants().getSegmentGeometryConstraint();
        if (rotation == SegmentsRotation.NIGHTY || rotation == SegmentsRotation.TWO_SEVENTY) {
            geomConstants = new SegmentGeometryConstants(geomConstants.getSegmentSerialActiveSize(), geomConstants.getSegmentParallelActiveSize(), geomConstants.getSegmentSerialPrescanSize());
        }
        return new Segment(geomConstants, channel);
    }

    static Segment createCCDSegment(CCDType ccdType, int channel) {
        return Segment.createCCDSegment(ccdType, channel, SegmentsRotation.ZERO);
    }

    public static enum SegmentsRotation {
        ZERO,
        NIGHTY,
        ONE_EIGHTY,
        TWO_SEVENTY;

    }
}

