package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 24V dirty SLAC PDU
 *
 *  @author  Owen Saxton
 */
public class Pdu24VD extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
        CHAN_FES_LOADER_D  = 0,
        CHAN_FES_CHANGER_D = 1,
        CHAN_CRYO_TURBO    = 2,
        CHAN_HEX_TURBO     = 3,
        CHAN_FES_CLAMPS    = 4,
        CHAN_FES_BRAKES    = 5,
        CHAN_SHUTTER_BRAKE = 6,
        NUM_CHANS          = 7;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("fesLoader", CHAN_FES_LOADER_D);
        CHANNEL_MAP.put("fesChanger", CHAN_FES_CHANGER_D);
        CHANNEL_MAP.put("cryoTurbo", CHAN_CRYO_TURBO);
        CHANNEL_MAP.put("hexTurbo", CHAN_HEX_TURBO);
        CHANNEL_MAP.put("fesClamps", CHAN_FES_CLAMPS);
        CHANNEL_MAP.put("fesBrakes", CHAN_FES_BRAKES);
        CHANNEL_MAP.put("shuBrakes", CHAN_SHUTTER_BRAKE);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_DIRTY);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x7f;


    /**
     *  Constructor.
     */
    public Pdu24VD()
    {
        super(NUM_CHANS, LambdaPS.MODEL_28);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
