/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.conv;

public class Convert {
    public static int bytesToInt(byte[] ba, int ix) {
        return ba[ix] & 0xFF | (ba[ix + 1] & 0xFF) << 8 | (ba[ix + 2] & 0xFF) << 16 | ba[ix + 3] << 24;
    }

    public static int bytesToIntBE(byte[] ba, int ix) {
        return ba[ix + 3] & 0xFF | (ba[ix + 2] & 0xFF) << 8 | (ba[ix + 1] & 0xFF) << 16 | ba[ix] << 24;
    }

    public static short bytesToShort(byte[] ba, int ix) {
        return (short)(ba[ix] & 0xFF | ba[ix + 1] << 8);
    }

    public static short bytesToShortBE(byte[] ba, int ix) {
        return (short)(ba[ix + 1] & 0xFF | ba[ix] << 8);
    }

    public static float bytesToFloat(byte[] ba, int ix) {
        int value = ba[ix] & 0xFF | (ba[ix + 1] & 0xFF) << 8 | (ba[ix + 2] & 0xFF) << 16 | ba[ix + 3] << 24;
        return Float.intBitsToFloat(value);
    }

    public static float bytesToFloatBE(byte[] ba, int ix) {
        int value = ba[ix + 3] & 0xFF | (ba[ix + 2] & 0xFF) << 8 | (ba[ix + 1] & 0xFF) << 16 | ba[ix] << 24;
        return Float.intBitsToFloat(value);
    }

    public static void intToBytes(int val, byte[] ba, int ix) {
        ba[ix] = (byte)val;
        ba[ix + 1] = (byte)(val >> 8);
        ba[ix + 2] = (byte)(val >> 16);
        ba[ix + 3] = (byte)(val >> 24);
    }

    public static void intToBytesBE(int val, byte[] ba, int ix) {
        ba[ix] = (byte)(val >> 24);
        ba[ix + 1] = (byte)(val >> 16);
        ba[ix + 2] = (byte)(val >> 8);
        ba[ix + 3] = (byte)val;
    }

    public static void shortToBytes(short val, byte[] ba, int ix) {
        ba[ix] = (byte)val;
        ba[ix + 1] = (byte)(val >> 8);
    }

    public static void shortToBytesBE(short val, byte[] ba, int ix) {
        ba[ix] = (byte)(val >> 8);
        ba[ix + 1] = (byte)val;
    }

    public static void floatToBytes(float val, byte[] ba, int ix) {
        int value = Float.floatToIntBits(val);
        ba[ix] = (byte)value;
        ba[ix + 1] = (byte)(value >> 8);
        ba[ix + 2] = (byte)(value >> 16);
        ba[ix + 3] = (byte)(value >> 24);
    }

    public static void floatToBytesBE(float val, byte[] ba, int ix) {
        int value = Float.floatToIntBits(val);
        ba[ix] = (byte)(value >> 24);
        ba[ix + 1] = (byte)(value >> 16);
        ba[ix + 2] = (byte)(value >> 8);
        ba[ix + 3] = (byte)value;
    }
}

