/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Predicate;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.annotations.Command;

public interface Dictionary
extends Iterable<DictionaryCommand>,
Serializable {
    public boolean containsCommand(BasicCommand var1) throws CommandArgumentMatchException;

    public DictionaryCommand findCommand(BasicCommand var1) throws CommandArgumentMatchException;

    public int size();

    default public DictionaryHelpGenerator getHelpGenerator() {
        return null;
    }

    default public DictionaryCompleter getDictionaryCompleter() {
        return null;
    }

    public void setLevel(int var1);

    public int getLevel();

    public void setVisibilityForTypes(Command.CommandType ... var1);

    public boolean getVisibilityForType(Command.CommandType var1);

    default public Iterable<DictionaryCommand> filterByLevelIterator() {
        return new Iterable<DictionaryCommand>(){

            @Override
            public Iterator<DictionaryCommand> iterator() {
                Iterator<DictionaryCommand> filteredIterator = new Iterator<DictionaryCommand>(){
                    private final Iterator<DictionaryCommand> superIterator;
                    private boolean hasNext;
                    private DictionaryCommand nextDC;
                    private final Predicate<DictionaryCommand> pred;
                    {
                        this.superIterator = Dictionary.this.iterator();
                        this.nextDC = null;
                        this.pred = dc -> dc.getLevel() <= Dictionary.this.getLevel() && Dictionary.this.getVisibilityForType(dc.getType());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public DictionaryCommand next() {
                        DictionaryCommand prevDC = this.nextDC;
                        while (this.superIterator.hasNext()) {
                            DictionaryCommand dc = this.superIterator.next();
                            if (!this.pred.test(dc)) continue;
                            this.hasNext = true;
                            this.nextDC = dc;
                            return prevDC;
                        }
                        this.hasNext = false;
                        return prevDC;
                    }
                };
                filteredIterator.next();
                return filteredIterator;
            }
        };
    }
}

