package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 ***************************************************
 * 
 *  Program to test the Agilent E3631 device driver
 * 
 *  @author Heather Kelly
 * 
 ***************************************************
 */
public class TestE3631 {

    protected E3631 ps;

    public enum OnOff {
        OFF, ON;
    }


   /**
    *  Opens connection to a device.
    * 
    *  @param  host  The network host name
    *
    *  @throws  DriverException
    */
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="devId", description="The device ID of the device to open")
                     String devId,
                     @Argument(name="baud", description="baud")
                     int baud 
                     ) throws DriverException
    {
        ps = new E3631();
        ps.open(devId, baud);
    }


   /**
    *  Opens connection to a device.
    * 
    *  @param  host  The network host name
    *
    *  @param  baud The baud rate 
    *
    *  @throws  DriverException
    */
    @Command(name="openftdi", description="Open FTDI connection to device")
    public void openftdi(@Argument(name="serialname", description="Serial device name")
                     String host,
                     @Argument(name="baud", description="baud")
                     int baud 
                     ) throws DriverException
    {
        ps = new E3631();
        ps.openftdi(host, baud);
    }


    @Command(name = "readident", description = "read IDN")
    public String readiden() throws Exception {
        return ps.getID();
    }

    @Command(name = "selectOutput", description = "select output from (P6V, P25V, N25V)")
    public void selectOutput(@Argument(name="output", description="Output (P6V, P25V, N25V)") String output) throws DriverException
    {
      ps.selectOutput(output);
    }

    @Command(name = "getOutput", description = "return currently selected output")
    public String getOutput() throws DriverException
    {
      return ps.getOutput();
    }

    @Command(name = "outputOn", description = "set output from (P6V, P25V, N25V) to on")
    public void outputOn(@Argument(name="output", description="Output (P6V, P25V, N25V)") String output) throws DriverException
    {
      ps.outputOn(output);
    }

    @Command(name = "outputOff", description = "set output from (P6V, P25V, N25V) to off")
    public void outputOff(@Argument(name="output", description="Output (P6V, P25V, N25V)") String output) throws DriverException
    {
      ps.outputOff(output);
    }

    @Command(name = "getVoltage", description = "read Voltage")
    public Double getVoltage() throws DriverException
   {
     return ps.getVoltage();
   }

    @Command(name = "getVoltage", description = "read Voltage")
    public Double getVoltage(@Argument(name="output", description="Output (P6V, P25V, N25V)") String output) throws DriverException
   {
     return ps.getVoltage(output);
   }

    @Command(name = "getCurrent", description = "read Current for current output")
    public Double getCurrent() throws DriverException
   {
     return ps.getCurrent();
   }

    @Command(name = "getCurrent", description = "read Current")
    public Double getCurrent(@Argument(name="output", description="Output (P6V, P25V, N25V)") String output) throws DriverException
   {
     return ps.getCurrent(output);
   }

   @Command(name="setVerbose", description="set verbose true or false")
   public void setVerbose(@Argument(name="flag", description="true or false")Boolean flag) throws DriverException {
       ps.setVerbose(flag);
   }

   @Command(name="setFakeout", description="set fakeout to true or false")
   public void setFakeout(@Argument(name="flag", description="true or false")Boolean flag) throws DriverException {
     ps.setFakeout(flag);
   }

}
