package org.lsst.ccs.drivers.agilent;

import java.io.BufferedReader;
import java.io.FileReader;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

/**
 ***********************************
 * 
 * Program to test a driver device
 * 
 * @author <your name here>
 * 
 ***********************************
 */
public class DeviceTestShell {

    private Device mydev;

    // constructor
    public DeviceTestShell() {
        try {
            mydev = new Device();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Command(description = "Open device for use\n" + 
                           "open [channelNumber] [powerSeq] [voltage] [currlm]")
    public String open(int channelNumber, int powerSeq, double voltage, 
                      double currlimt) throws Exception {
        try {
            mydev.init("127.0.0.1", channelNumber, powerSeq, voltage, currlimt);
        } catch (Exception e) {
            return e.getMessage();
        }
        return "Good";
    }
    
    @Command(description = "Open config file and connection to power supply\n" + 
                           "load [filename] [hostname]")
    public String load(String fname, String hostname) throws Exception {
        BufferedReader in = null;
        String str;
        int    chanNum      = 0;
        int    powerSeq     = 0;
        double setVolt      = 0.0;
        double setCurrLimit = 0.0;

        try {
            in = new BufferedReader(new FileReader(fname));
        }
        catch (Exception e) {
            return e.getMessage();
        }

        while ((str = in.readLine()) != null) {
            if (str.charAt(0) != '#') {
                str = str.replaceAll("\\s+","");
                String[] strArr = str.split(",");
                System.out.println(str);
                
                if (strArr.length == 4) {
                    chanNum = Integer.parseInt(strArr[0]);
                    setVolt = Double.parseDouble(strArr[1]);
                    setCurrLimit = Double.parseDouble(strArr[2]); 
                    powerSeq = Integer.parseInt(strArr[3]);

                    try {
                        mydev.init(hostname, chanNum, powerSeq, setVolt, 
                                   setCurrLimit);
                    } catch (Exception e) {
                        return e.getMessage();
                    }

                }
            }
        }
        in.close();
        return "OK";
    }

    @Command(description = "Set voltage, current limit in the proper order.")
    public String powerOn() throws Exception {
        try {
            mydev.powerOn();
        } catch (Exception e) {
            return e.getMessage();
        }
        return "Good";
    }

    @Command(description = "Power off channels")
    public String powerOff() throws Exception {
        try {
            mydev.powerOff();
        } catch (Exception e) {
            return e.getMessage();
        }
        return "Good";
    }

    @Command(description = "Return readback voltage from a channel\n" +
                           "chanVoltage [channel]")
    public String chanVoltage(int channel) throws Exception {
        String ret = "";
        try {
            ret = Double.toString(mydev.chanVoltage(channel));
        } catch (Exception e) {
            return e.getMessage();
        }
        return ret;

    }
    

    // Stolen from http://stackoverflow.com/questions/332079
    static String toHex(byte[] digest) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            int bi = b & 0xff;
            sb.append(digits.charAt(bi >> 4));
            sb.append(digits.charAt(bi & 0xf));
        }
        return sb.toString();
    }

}
