/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.Arrays;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.MethodBasedDictionaryArgument;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

class MethodBasedDictionaryCommand
implements DictionaryCommand {
    private final String description;
    private final String[] aliases;
    private final DictionaryArgument[] params;
    private final Command.CommandType type;
    private final Command.CommandCategory category;
    private final String name;
    private final boolean hasVarArgs;
    private final int level;
    private final boolean autoAck;
    private final Duration timeout;
    private static final long serialVersionUID = -2134147357955297580L;

    MethodBasedDictionaryCommand(Method annotatedMethod, Command annotation) {
        this.description = annotation.description();
        this.aliases = this.splitAliases(annotation.alias());
        this.type = annotation.type();
        this.category = annotation.category();
        this.name = annotation.name().isEmpty() ? annotatedMethod.getName() : annotation.name();
        this.hasVarArgs = annotatedMethod.isVarArgs();
        this.level = annotation.level();
        this.autoAck = annotation.autoAck();
        this.timeout = annotation.timeout() > 0 ? Duration.ofSeconds(annotation.timeout()) : null;
        Class<?>[] types = annotatedMethod.getParameterTypes();
        Annotation[][] parAnnotations = annotatedMethod.getParameterAnnotations();
        this.params = new MethodBasedDictionaryArgument[types.length];
        Parameter[] methodParameters = annotatedMethod.getParameters();
        for (int i = 0; i < types.length; ++i) {
            String parName = methodParameters[i].getName();
            String parDescription = "";
            String defaultValue = "***NULL_VALUE_FOR_COMMAND_ARGUMENT***";
            for (Annotation a : parAnnotations[i]) {
                if (!(a instanceof Argument)) continue;
                Argument paramAnnotation = (Argument)a;
                parName = paramAnnotation.name().isEmpty() ? parName : paramAnnotation.name();
                parDescription = paramAnnotation.description();
                if (paramAnnotation.defaultValue().equals("***NULL_VALUE_FOR_COMMAND_ARGUMENT***")) break;
                defaultValue = paramAnnotation.defaultValue();
                break;
            }
            Class<?> parameterType = this.hasVarArgs && i == types.length - 1 ? types[i].getComponentType() : types[i];
            this.params[i] = new MethodBasedDictionaryArgument(parName, parameterType, parDescription, defaultValue);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public DictionaryArgument[] getArguments() {
        return this.params;
    }

    @Override
    public Command.CommandType getType() {
        return this.type;
    }

    @Override
    public Command.CommandCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    @Override
    public boolean isVarArgs() {
        return this.hasVarArgs;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    private String[] splitAliases(String alias) {
        return alias.length() > 0 ? alias.split("\\s?,\\s?") : NO_ALIASES;
    }

    public String toString() {
        return "MethodBasedDictionaryCommand{description='" + this.description + '\'' + ", aliases=" + Arrays.toString(this.aliases) + ", params=" + Arrays.toString(this.params) + ", type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", hasVarArgs=" + this.hasVarArgs + '}';
    }
}

