/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ResourceDirectory {
    private File resourceDirectoryFile = null;
    private List<String> resources = new ArrayList<String>();
    private String fileSeparator = System.getProperty("file.separator");

    ResourceDirectory(String resourceDirectoryPath) {
        this.resourceDirectoryFile = new File(resourceDirectoryPath);
        this.loadResources(this.resourceDirectoryFile, this.fileSeparator);
    }

    private void loadResources(File parent, String relPath) {
        if (parent.exists() && parent.isDirectory()) {
            String[] listOfResources;
            String[] stringArray = listOfResources = parent.list();
            int n = listOfResources.length;
            int n2 = 0;
            while (n2 < n) {
                String resource = stringArray[n2];
                File f = new File(parent, resource);
                if (f.isDirectory()) {
                    this.loadResources(f, String.valueOf(relPath) + resource + this.fileSeparator);
                } else {
                    String resourceName = String.valueOf(relPath) + resource;
                    if (resourceName.startsWith(this.fileSeparator)) {
                        resourceName = resourceName.substring(1);
                    }
                    this.resources.add(resourceName);
                }
                ++n2;
            }
        } else {
            throw new IllegalArgumentException("The provided path: " + parent.getAbsolutePath() + " does not exist");
        }
    }

    public boolean hasResource(String resourceName) {
        return this.resources.contains(resourceName);
    }

    public String getResouceDirectoryPath() {
        String resourceDirPath = this.resourceDirectoryFile.getAbsolutePath();
        if (!resourceDirPath.endsWith(this.fileSeparator)) {
            resourceDirPath = String.valueOf(resourceDirPath) + this.fileSeparator;
        }
        return resourceDirPath;
    }

    public List<String> getResources() {
        return this.resources;
    }
}

