/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.structs;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreeNode;

public class TreeBranch<T extends Serializable>
implements Serializable,
TreeNode,
Iterable<T> {
    private static final long serialVersionUID = -8299651867210784530L;
    private TreeBranch<T> parent;
    private ArrayList<TreeBranch<T>> children;
    private T content;
    private int currentIndex = -1;

    public TreeBranch(T content) {
        this.content = content;
    }

    protected TreeBranch() {
    }

    @ConstructorProperties(value={"realParent", "content"})
    public TreeBranch(TreeBranch<T> parent, T content) {
        this.parent = parent;
        this.content = content;
        if (parent != null) {
            this.parent.addChild(this);
        }
    }

    public synchronized void addChild(TreeBranch<T> child) {
        if (child == null) {
            throw new IllegalArgumentException("null child");
        }
        if (child.parent != null) {
            throw new IllegalArgumentException("node already part of another tree");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        int index = this.children.size();
        this.children.add(child);
        child.currentIndex = index;
        child.parent = this;
    }

    public T getContent() {
        return this.content;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public Iterator<T> iterator() {
        return new PreOrderIterator(this);
    }

    public Iterator<TreeBranch<T>> nodeIterator() {
        return new PreOrderNodeIterator(this);
    }

    public List<TreeBranch<T>> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        return Collections.emptyList();
    }

    public Iterator<TreeBranch<T>> getChildIterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.emptyIterator();
    }

    public List<TreeBranch<T>> getPath() {
        ArrayList<TreeBranch<T>> res = new ArrayList<TreeBranch<T>>();
        TreeBranch<T> curNode = this;
        while ((curNode = curNode.getRealParent()) != null) {
            res.add(curNode);
        }
        Collections.reverse(res);
        return res;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.children != null) {
            if (childIndex >= this.children.size() || childIndex < 0) {
                return null;
            }
            TreeBranch<T> res = this.children.get(childIndex);
            assert (childIndex == res.currentIndex);
            return res;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public TreeBranch<T> getRealParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node.getParent() != this) {
            return -1;
        }
        if (this.children != null) {
            TreeBranch branch = (TreeBranch)node;
            return branch.currentIndex;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.children != null;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public Enumeration children() {
        return new Enumeration(){
            final Iterator iter;
            {
                this.iter = TreeBranch.this.children.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public String toString() {
        return String.valueOf(this.content);
    }

    protected static class PreOrderIterator<X extends Serializable>
    implements Iterator<X> {
        private final PreOrderNodeIterator<X> preOrderNodeIterator;

        public PreOrderIterator(TreeBranch<X> rootNode) {
            this.preOrderNodeIterator = new PreOrderNodeIterator<X>(rootNode);
        }

        @Override
        public X next() {
            Object node = this.preOrderNodeIterator.next();
            return (X)((TreeBranch)node).getContent();
        }

        @Override
        public boolean hasNext() {
            return this.preOrderNodeIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    protected static class PreOrderNodeIterator<X extends Serializable>
    implements Iterator<TreeBranch<X>> {
        private final Stack<Iterator<TreeBranch<X>>> stack = new Stack();

        public PreOrderNodeIterator(TreeBranch<X> rootNode) {
            ArrayList<TreeBranch<X>> v = new ArrayList<TreeBranch<X>>(1);
            v.add(rootNode);
            this.stack.push(v.iterator());
        }

        @Override
        public TreeBranch<X> next() {
            Iterator<TreeBranch<X>> iter = this.stack.peek();
            TreeBranch<X> node = iter.next();
            Iterator<TreeBranch<X>> childrens = node.getChildIterator();
            if (!iter.hasNext()) {
                this.stack.pop();
            }
            if (childrens.hasNext()) {
                this.stack.push(childrens);
            }
            return node;
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

