/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.mockito.Mockito;

public class NotificationTest {
    private static final int TEST_HANDLE = 123;
    private static VariableHandle varHandle;
    private static ByteBuffer buff;
    private static Notification notice;

    @BeforeAll
    private static void setup() {
        varHandle = (VariableHandle)Mockito.mock(VariableHandle.class);
        buff = (ByteBuffer)Mockito.mock(ByteBuffer.class);
        notice = new Notification(123, varHandle, buff);
    }

    @Test
    @DisplayName(value="Getting the notification handle value.")
    public void testGetNotificationHandle() {
        int expResult = 123;
        int result = notice.getNotificationHandle();
        Assertions.assertEquals((int)expResult, (int)result, (String)"Wrong notification handle.");
    }

    @Test
    @DisplayName(value="Getting the VariableHandle.")
    public void testGetVariableHandle() {
        VariableHandle result = notice.getVariableHandle();
        Assertions.assertEquals((Object)varHandle, (Object)result, (String)"Wrong variable handle.");
        Mockito.verifyZeroInteractions((Object[])new Object[]{result});
    }

    @Test
    @DisplayName(value="Getting the data buffer.")
    public void testGetData() {
        ByteBuffer result = notice.getData();
        Assertions.assertEquals((Object)buff, (Object)result, (String)"Wrong ByteBuffer instance.");
        Mockito.verifyZeroInteractions((Object[])new Object[]{result});
    }
}

