package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Callback;

/**
 * Functional interface for notification callbacks from the ADS library
 * to Java.
 */
public interface PAdsNotificationFuncEx extends Callback {
    /**
     * Type definition of the callback function required by the AdsSyncAddDeviceNotificationReqEx() function.
     * @param pAddr (In) Structure with NetId and port number of the ADS server.
     * @param pNotification (In) Pointer to a notification header.
     * @param hUser (In) Custom data passed to AdsSyncAddDeviceNotificationReqEx() during registration.
     */
    void apply(AmsAddr pAddr, AdsNotificationHeader pNotification, int hUser);
}
