package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * The complete address, net ID and port, of an ADS device can be stored
 * in this structure. Note that an AMS port is not a TCP port.
 */
public class AmsAddr extends Structure {
    /** AMS Net Id */
    public AmsNetId netId;
    
    /** AMS Port number */
    public short port;

    public AmsAddr(AmsNetId netId, short port) {
        super(ALIGN_NONE);  // pack(1) pragma was used in AdsDef.h
        this.netId = netId;
        this.port = port;
    }
    
    /** For use by JNA. */
    public AmsAddr() {
        super(ALIGN_NONE);
        this.netId = new AmsNetId();
        this.port = 0;
    }
    
    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("netId", "port");
    }
    
    @Override
    public String toString() {
        return netId.toString() + ":" + port;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.netId);
        hash = 59 * hash + this.port;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final AmsAddr other = (AmsAddr) obj;
        if (this.port != other.port) {
            return false;
        }
        if (!Objects.equals(this.netId, other.netId)) {
            return false;
        }
        return true;
    }

}
